/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.libs.gson.JsonArray;
import xyz.jonesdev.sonar.libs.gson.JsonElement;
import xyz.jonesdev.sonar.libs.gson.JsonObject;
import xyz.jonesdev.sonar.libs.gson.JsonParser;
import xyz.jonesdev.sonar.libs.gson.JsonPrimitive;
import xyz.jonesdev.sonar.libs.gson.internal.LazilyParsedNumber;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.BinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.BinaryTagType;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.BinaryTagTypes;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.ByteArrayBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.ByteBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.CompoundBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.DoubleBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.EndBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.FloatBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.IntArrayBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.IntBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.ListBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.LongArrayBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.LongBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.ShortBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.nbt.StringBinaryTag;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.Component;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

public final class ComponentHolder {
    private final String modernJson;
    private final String legacyJson;
    private final BinaryTag binaryTag;

    public ComponentHolder(@NotNull Component component) {
        this.modernJson = (String)GsonComponentSerializer.gson().serialize(component);
        this.legacyJson = (String)GsonComponentSerializer.colorDownsamplingGson().serialize(component);
        this.binaryTag = ComponentHolder.serialize(new JsonParser().parse(this.modernJson));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BinaryTag serialize(@NotNull JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            if (jsonPrimitive.isNumber()) {
                Number number = json.getAsNumber();
                if (number instanceof Byte) {
                    return ByteBinaryTag.byteBinaryTag((byte)((Byte)number));
                }
                if (number instanceof Short) {
                    return ShortBinaryTag.shortBinaryTag((short)((Short)number));
                }
                if (number instanceof Integer) {
                    return IntBinaryTag.intBinaryTag((int)((Integer)number));
                }
                if (number instanceof Long) {
                    return LongBinaryTag.longBinaryTag((long)((Long)number));
                }
                if (number instanceof Float) {
                    return FloatBinaryTag.floatBinaryTag((float)((Float)number).floatValue());
                }
                if (number instanceof Double) {
                    return DoubleBinaryTag.doubleBinaryTag((double)((Double)number));
                }
                if (!(number instanceof LazilyParsedNumber)) return EndBinaryTag.endBinaryTag();
                return IntBinaryTag.intBinaryTag((int)number.intValue());
            }
            if (jsonPrimitive.isString()) {
                return StringBinaryTag.stringBinaryTag((String)jsonPrimitive.getAsString());
            }
            if (!jsonPrimitive.isBoolean()) throw new IllegalArgumentException("Unknown JSON primitive: " + String.valueOf(jsonPrimitive));
            return ByteBinaryTag.byteBinaryTag((byte)((byte)(jsonPrimitive.getAsBoolean() ? 1 : 0)));
        }
        if (json instanceof JsonObject) {
            CompoundBinaryTag.Builder compound = CompoundBinaryTag.builder();
            for (Map.Entry property : ((JsonObject)json).entrySet()) {
                compound.put((String)property.getKey(), ComponentHolder.serialize((JsonElement)property.getValue()));
            }
            return compound.build();
        }
        if (!(json instanceof JsonArray)) return EndBinaryTag.endBinaryTag();
        JsonArray jsonArray = json.getAsJsonArray();
        if (jsonArray.size() == 0) {
            return ListBinaryTag.empty();
        }
        ArrayList<BinaryTag> tagItems = new ArrayList<BinaryTag>(jsonArray.size());
        BinaryTagType listType = null;
        for (JsonElement jsonEl : jsonArray) {
            BinaryTag tag2 = ComponentHolder.serialize(jsonEl);
            tagItems.add(tag2);
            if (listType == null) {
                listType = tag2.type();
                continue;
            }
            if (listType == tag2.type()) continue;
            listType = BinaryTagTypes.COMPOUND;
        }
        switch (((BinaryTagType)Objects.requireNonNull(listType)).id()) {
            case 1: {
                byte[] bytes = new byte[jsonArray.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = jsonArray.get(i).getAsNumber().byteValue();
                }
                return ByteArrayBinaryTag.byteArrayBinaryTag((byte[])bytes);
            }
            case 3: {
                int[] ints = new int[jsonArray.size()];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = jsonArray.get(i).getAsNumber().intValue();
                }
                return IntArrayBinaryTag.intArrayBinaryTag((int[])ints);
            }
            case 4: {
                long[] longs = new long[jsonArray.size()];
                for (int i = 0; i < longs.length; ++i) {
                    longs[i] = jsonArray.get(i).getAsNumber().longValue();
                }
                return LongArrayBinaryTag.longArrayBinaryTag((long[])longs);
            }
            case 10: {
                tagItems.replaceAll(tag -> {
                    if (tag.type() == BinaryTagTypes.COMPOUND) {
                        return tag;
                    }
                    return ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("", tag)).build();
                });
            }
        }
        return ListBinaryTag.listBinaryTag(listType, tagItems);
    }

    public void write(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion, boolean forceJson) {
        if (!forceJson && protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20_3)) {
            ProtocolUtil.writeBinaryTag(byteBuf, protocolVersion, this.binaryTag);
        } else {
            ProtocolUtil.writeString(byteBuf, protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_16) ? this.modernJson : this.legacyJson);
        }
    }
}

