/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.libs.kyori.adventure.text.serializer.gson;

import java.io.IOException;
import xyz.jonesdev.sonar.libs.gson.Gson;
import xyz.jonesdev.sonar.libs.gson.TypeAdapter;
import xyz.jonesdev.sonar.libs.gson.stream.JsonReader;
import xyz.jonesdev.sonar.libs.gson.stream.JsonWriter;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.Component;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.ComponentLike;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.TranslationArgument;
import xyz.jonesdev.sonar.libs.kyori.adventure.text.serializer.gson.SerializerFactory;

final class TranslationArgumentSerializer
extends TypeAdapter<TranslationArgument> {
    private final Gson gson;

    static TypeAdapter<TranslationArgument> create(Gson gson) {
        return new TranslationArgumentSerializer(gson).nullSafe();
    }

    private TranslationArgumentSerializer(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, TranslationArgument value) throws IOException {
        Object raw = value.value();
        if (raw instanceof Boolean) {
            out.value((Boolean)raw);
        } else if (raw instanceof Number) {
            out.value((Number)raw);
        } else if (raw instanceof Component) {
            this.gson.toJson(raw, SerializerFactory.COMPONENT_TYPE, out);
        } else {
            throw new IllegalStateException("Unable to serialize translatable argument of type " + raw.getClass() + ": " + raw);
        }
    }

    public TranslationArgument read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case BOOLEAN: {
                return TranslationArgument.bool(in.nextBoolean());
            }
            case NUMBER: {
                return TranslationArgument.numeric((Number)this.gson.fromJson(in, Number.class));
            }
        }
        return TranslationArgument.component((ComponentLike)this.gson.fromJson(in, SerializerFactory.COMPONENT_TYPE));
    }
}

