/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.command.subcommand;

import java.util.Objects;
import java.util.regex.Pattern;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.command.InvocationSource;
import xyz.jonesdev.sonar.api.command.subcommand.SubcommandInfo;

public abstract class Subcommand {
    @NotNull
    private final SubcommandInfo info = Objects.requireNonNull(this.getClass().getAnnotation(SubcommandInfo.class));
    private final String permission = "sonar." + this.info.name();
    private final String aliases = this.info.aliases().length == 0 ? "No aliases." : String.join((CharSequence)", ", this.info.aliases());
    private final String arguments = this.info.arguments().length == 0 ? "" : String.join((CharSequence)", ", this.info.arguments());
    private static final Pattern IPv4_REGEX = Pattern.compile("^((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}$");
    private static final Pattern IPv6_REGEX = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");

    @Nullable
    protected static String validateIP(InvocationSource source, String raw) {
        if (!IPv4_REGEX.matcher(raw).matches() && !IPv6_REGEX.matcher(raw).matches()) {
            source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.invalid-ip-address"), (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())));
            return null;
        }
        return raw;
    }

    protected final void incorrectUsage(@NotNull InvocationSource invocationSource) {
        this.incorrectUsage(invocationSource, this.info.name() + " (" + this.arguments + ")");
    }

    protected final void incorrectUsage(@NotNull InvocationSource invocationSource, String usage) {
        invocationSource.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.incorrect-usage"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"subcommand-usage", (String)usage)}));
    }

    public final void invoke(@NotNull InvocationSource invocationSource, String @NotNull [] arguments) {
        if (this.info.onlyPlayers() && !invocationSource.isPlayer()) {
            invocationSource.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.player-only"), (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())));
            return;
        }
        if (this.info.onlyConsole() && invocationSource.isPlayer()) {
            invocationSource.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.console-only"), (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())));
            return;
        }
        if (this.info.argumentsRequired() && this.info.arguments().length > 0 && arguments.length <= 1) {
            this.incorrectUsage(invocationSource);
            return;
        }
        this.execute(invocationSource, arguments);
    }

    @NotNull
    public final String getDescription() {
        String path = String.format("commands.%s.description", this.info.name());
        return Objects.requireNonNull(Sonar.get0().getConfig().getMessagesConfig().getString(path));
    }

    protected abstract void execute(@NotNull InvocationSource var1, String @NotNull [] var2);

    @NotNull
    public SubcommandInfo getInfo() {
        return this.info;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getAliases() {
        return this.aliases;
    }

    public String getArguments() {
        return this.arguments;
    }
}

