/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.notification;

import java.util.List;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.notification.NotificationHandler;
import xyz.jonesdev.sonar.api.profiler.SimpleProcessProfiler;
import xyz.jonesdev.sonar.api.timer.SystemTimer;
import xyz.jonesdev.sonar.api.tracker.AttackTracker;

public class ActionBarNotificationHandler
extends NotificationHandler {
    protected int animationIndex;

    @Override
    public void handleNotification() {
        if (this.subscribers.isEmpty()) {
            return;
        }
        AttackTracker.AttackStatistics attackStatistics = Sonar.get0().getAttackTracker().getCurrentAttack();
        SystemTimer attackTimer = attackStatistics == null ? null : attackStatistics.getDuration();
        String attackDuration = attackTimer == null ? "00:00" : SystemTimer.DATE_FORMATTER.format(attackTimer.delay());
        Component actionBarComponent = MiniMessage.miniMessage().deserialize(attackTimer == null ? Sonar.get0().getConfig().getMessagesConfig().getString("verbose.layout.normal") : Sonar.get0().getConfig().getMessagesConfig().getString("verbose.layout.attack"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"attack-duration", (String)attackDuration), Placeholder.unparsed((String)"animation", (String)this.nextAnimation()), Placeholder.unparsed((String)"process-cpu", (String)Sonar.DECIMAL_FORMAT.format(SimpleProcessProfiler.getProcessCPUUsage())), Placeholder.unparsed((String)"system-cpu", (String)Sonar.DECIMAL_FORMAT.format(SimpleProcessProfiler.getSystemCPUUsage())), Placeholder.unparsed((String)"queued", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getFallback().getQueue().getPlayers().size())), Placeholder.unparsed((String)"verifying", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getFallback().getConnected().size())), Placeholder.unparsed((String)"blacklisted", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getFallback().getBlacklist().estimatedSize())), Placeholder.unparsed((String)"total-joins", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalPlayersJoined())), Placeholder.unparsed((String)"logins-per-second", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getLoginsPerSecond())), Placeholder.unparsed((String)"connections-per-second", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getConnectionsPerSecond())), Placeholder.unparsed((String)"verify-total", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalAttemptedVerifications())), Placeholder.unparsed((String)"verify-success", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalSuccessfulVerifications())), Placeholder.unparsed((String)"verify-failed", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalFailedVerifications())), Placeholder.unparsed((String)"incoming-traffic", (String)Sonar.get0().getStatistics().getPerSecondIncomingBandwidthFormatted()), Placeholder.unparsed((String)"outgoing-traffic", (String)Sonar.get0().getStatistics().getPerSecondOutgoingBandwidthFormatted()), Placeholder.unparsed((String)"incoming-traffic-ttl", (String)SimpleProcessProfiler.formatMemory(Sonar.get0().getStatistics().getTotalIncomingBandwidth())), Placeholder.unparsed((String)"outgoing-traffic-ttl", (String)SimpleProcessProfiler.formatMemory(Sonar.get0().getStatistics().getTotalOutgoingBandwidth())), Placeholder.unparsed((String)"used-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getUsedMemory())), Placeholder.unparsed((String)"free-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getFreeMemory())), Placeholder.unparsed((String)"total-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getTotalMemory())), Placeholder.unparsed((String)"max-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getMaxMemory()))});
        for (UUID subscriber : this.subscribers) {
            Audience audience = Sonar.get0().audience(subscriber);
            if (audience == null) continue;
            audience.sendActionBar(actionBarComponent);
        }
    }

    public String nextAnimation() {
        List<String> animations = Sonar.get0().getConfig().getVerboseAnimation();
        int nextIndex = ++this.animationIndex % animations.size();
        return animations.toArray(new String[0])[nextIndex];
    }

    public int getAnimationIndex() {
        return this.animationIndex;
    }
}

