/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.tracker;

import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.config.SonarConfiguration;
import xyz.jonesdev.sonar.api.event.impl.AttackDetectedEvent;
import xyz.jonesdev.sonar.api.event.impl.AttackMitigatedEvent;
import xyz.jonesdev.sonar.api.profiler.SimpleProcessProfiler;
import xyz.jonesdev.sonar.api.timer.SystemTimer;

public final class AttackTracker {
    public static final AttackTracker INSTANCE = new AttackTracker();
    @Nullable
    private AttackStatistics currentAttack;
    private int attackThreshold;

    public void checkIfUnderAttack() {
        long joinsPerSecond = Sonar.get0().getStatistics().getLoginsPerSecond();
        int verifyingPlayers = Sonar.get0().getFallback().getConnected().size();
        int queuedPlayers = Sonar.get0().getFallback().getQueue().getPlayers().size();
        int minPlayers = Sonar.get0().getConfig().getMinPlayersForAttack();
        if (joinsPerSecond > (long)minPlayers || verifyingPlayers > minPlayers || queuedPlayers > minPlayers) {
            long processMemoryUsage;
            double processCPUUsage;
            long connectionsPerSecond;
            ++this.attackThreshold;
            if (this.currentAttack == null) {
                this.currentAttack = new AttackStatistics();
                this.currentAttack.successfulVerifications = Sonar.get0().getVerifiedPlayerController().getCache().size();
                this.currentAttack.failedVerifications = Sonar.get0().getStatistics().getTotalFailedVerifications();
                Sonar.get0().getEventManager().publish(new AttackDetectedEvent());
                Sonar.get0().getChatNotificationHandler().handleNotification();
            } else {
                this.currentAttack.timer.reset();
            }
            if (joinsPerSecond > this.currentAttack.peakJoinsPerSecond) {
                this.currentAttack.peakJoinsPerSecond = joinsPerSecond;
            }
            if ((connectionsPerSecond = Sonar.get0().getStatistics().getConnectionsPerSecond()) > this.currentAttack.peakConnectionsPerSecond) {
                this.currentAttack.peakConnectionsPerSecond = connectionsPerSecond;
            }
            if ((processCPUUsage = SimpleProcessProfiler.getProcessCPUUsage()) > this.currentAttack.peakProcessCPUUsage) {
                this.currentAttack.peakProcessCPUUsage = processCPUUsage;
            }
            if ((processMemoryUsage = SimpleProcessProfiler.getUsedMemory()) > this.currentAttack.peakProcessMemoryUsage) {
                this.currentAttack.peakProcessMemoryUsage = processMemoryUsage;
            }
        } else if (this.currentAttack != null) {
            if (this.currentAttack.duration.delay() > (long)Sonar.get0().getConfig().getMinAttackDuration() && this.currentAttack.timer.delay() > (long)Sonar.get0().getConfig().getAttackCooldownDelay()) {
                Sonar.get0().getEventManager().publish(new AttackMitigatedEvent(this.currentAttack));
                if (++this.attackThreshold > Sonar.get0().getConfig().getMinAttackThreshold()) {
                    Optional.ofNullable(Sonar.get0().getConfig().getWebhook().getDiscordWebhook()).ifPresent(webhook -> {
                        long deltaInMillis = this.currentAttack.duration.delay();
                        String peakCPU = Sonar.DECIMAL_FORMAT.format(this.currentAttack.peakProcessCPUUsage);
                        String peakMem = SimpleProcessProfiler.formatMemory(this.currentAttack.peakProcessMemoryUsage);
                        String peakBPS = Sonar.DECIMAL_FORMAT.format(this.currentAttack.peakJoinsPerSecond);
                        String peakCPS = Sonar.DECIMAL_FORMAT.format(this.currentAttack.peakConnectionsPerSecond);
                        long minutes = deltaInMillis / 60000L;
                        double seconds = (double)(deltaInMillis % 60000L) / 1000.0;
                        String formattedDuration = String.format("%d minutes, %.0f seconds", minutes, seconds);
                        String startTimestamp = String.valueOf(this.currentAttack.duration.getStart() / 1000L);
                        String endTimestamp = String.valueOf(System.currentTimeMillis() / 1000L);
                        long blacklisted = Sonar.get0().getFallback().getBlacklist().estimatedSize();
                        long totalVerified = Sonar.get0().getVerifiedPlayerController().getCache().size();
                        long verified = Math.max(totalVerified - (long)this.currentAttack.successfulVerifications, 0L);
                        long totalFailed = Sonar.get0().getStatistics().getTotalFailedVerifications();
                        long failed = Math.max(totalFailed - (long)this.currentAttack.failedVerifications, 0L);
                        webhook.post(() -> {
                            SonarConfiguration.Webhook.Embed config = Sonar.get0().getConfig().getWebhook().getEmbed();
                            String description = config.getDescription().replace("<start-timestamp>", startTimestamp).replace("<end-timestamp>", endTimestamp).replace("<attack-duration>", formattedDuration).replace("<peak-cpu>", peakCPU).replace("<peak-memory>", peakMem).replace("<peak-bps>", peakBPS).replace("<peak-cps>", peakCPS).replace("<total-blacklisted>", Sonar.DECIMAL_FORMAT.format(blacklisted)).replace("<total-failed>", Sonar.DECIMAL_FORMAT.format(failed)).replace("<total-success>", Sonar.DECIMAL_FORMAT.format(verified));
                            return new SonarConfiguration.Webhook.Embed(config.getTitle(), config.getTitleUrl(), description, config.getR(), config.getG(), config.getB());
                        });
                    });
                }
                this.currentAttack = null;
                this.attackThreshold = 0;
            }
        } else {
            this.attackThreshold = 0;
        }
    }

    @Nullable
    public AttackStatistics getCurrentAttack() {
        return this.currentAttack;
    }

    public int getAttackThreshold() {
        return this.attackThreshold;
    }

    private AttackTracker() {
    }

    public static final class AttackStatistics {
        private final SystemTimer duration = new SystemTimer();
        private final SystemTimer timer = new SystemTimer();
        private long peakJoinsPerSecond;
        private long peakConnectionsPerSecond;
        private double peakProcessCPUUsage;
        private long peakProcessMemoryUsage;
        private int successfulVerifications;
        private int failedVerifications;

        public SystemTimer getDuration() {
            return this.duration;
        }

        public SystemTimer getTimer() {
            return this.timer;
        }

        public long getPeakJoinsPerSecond() {
            return this.peakJoinsPerSecond;
        }

        public long getPeakConnectionsPerSecond() {
            return this.peakConnectionsPerSecond;
        }

        public double getPeakProcessCPUUsage() {
            return this.peakProcessCPUUsage;
        }

        public long getPeakProcessMemoryUsage() {
            return this.peakProcessMemoryUsage;
        }

        public int getSuccessfulVerifications() {
            return this.successfulVerifications;
        }

        public int getFailedVerifications() {
            return this.failedVerifications;
        }

        public String toString() {
            return "AttackTracker.AttackStatistics(duration=" + String.valueOf(this.getDuration()) + ", timer=" + String.valueOf(this.getTimer()) + ", peakJoinsPerSecond=" + this.getPeakJoinsPerSecond() + ", peakConnectionsPerSecond=" + this.getPeakConnectionsPerSecond() + ", peakProcessCPUUsage=" + this.getPeakProcessCPUUsage() + ", peakProcessMemoryUsage=" + this.getPeakProcessMemoryUsage() + ", successfulVerifications=" + this.getSuccessfulVerifications() + ", failedVerifications=" + this.getFailedVerifications() + ")";
        }
    }
}

