/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api.update;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.libs.gson.JsonObject;

public final class UpdateChecker {
    private static final ExecutorService ASYNC_EXECUTOR = Executors.newSingleThreadExecutor();
    private static CheckResult lastCheckResult = CheckResult.UNRESOLVED;

    public static void checkForUpdates() {
        ASYNC_EXECUTOR.execute(() -> {
            try {
                URL url = new URL("https://api.github.com/repos/jonesdevelopment/sonar/releases/latest");
                HttpsURLConnection urlConnection = UpdateChecker.prepareConnection(url);
                JsonObject json = UpdateChecker.parseJson(urlConnection);
                String latestStableRelease = json.get("tag_name").getAsString();
                int convertedLatestVersion = UpdateChecker.convertVersion(latestStableRelease);
                int convertedCurrentVersion = UpdateChecker.convertVersion(Sonar.get0().getVersion().getVersion());
                if (convertedCurrentVersion < convertedLatestVersion) {
                    Sonar.get0().getLogger().warn("A new version of Sonar is available: {}", latestStableRelease);
                    Sonar.get0().getLogger().warn("Please make sure to update to the latest version to ensure stability and security:", new Object[0]);
                    Sonar.get0().getLogger().warn("https://github.com/jonesdevelopment/sonar/releases/latest", new Object[0]);
                    lastCheckResult = CheckResult.OUTDATED_VERSION;
                } else if (convertedCurrentVersion > convertedLatestVersion || !Sonar.get0().getVersion().getGitBranch().equals("main")) {
                    Sonar.get0().getLogger().warn("You are currently using an unreleased version of Sonar!", new Object[0]);
                    Sonar.get0().getLogger().warn("The contributors of Sonar are not responsible for any damage done by using an unstable version", new Object[0]);
                    lastCheckResult = CheckResult.UNSTABLE_VERSION;
                } else if (lastCheckResult != CheckResult.LATEST_VERSION) {
                    Sonar.get0().getLogger().info("You are currently using the latest stable release of Sonar!", new Object[0]);
                    lastCheckResult = CheckResult.LATEST_VERSION;
                }
            }
            catch (Throwable throwable) {
                Sonar.get0().getLogger().warn("Unable to retrieve version information: {}", throwable);
                lastCheckResult = CheckResult.API_ERROR;
            }
        });
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static JsonObject parseJson(@NotNull HttpsURLConnection urlConnection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static HttpsURLConnection prepareConnection(@NotNull URL url) throws Exception {
        HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
        urlConnection.setConnectTimeout(15000);
        urlConnection.setReadTimeout(15000);
        urlConnection.setRequestProperty("Accept", "application/vnd.github.v3+json");
        if (urlConnection.getResponseCode() != 200) {
            throw new IllegalStateException("Unexpected response code " + urlConnection.getResponseCode());
        }
        return urlConnection;
    }

    private static int convertVersion(@NotNull String version) throws NumberFormatException, IllegalStateException {
        String[] convertedParts = version.split("\\.");
        if (convertedParts.length != 3) {
            throw new IllegalStateException("Converted version length mismatch");
        }
        int convertedMajor = Integer.parseInt(convertedParts[0]) * 100000;
        int convertedMinor = Integer.parseInt(convertedParts[1]) * 10000;
        int patch = Integer.parseInt(convertedParts[2]);
        return convertedMajor + convertedMinor + patch;
    }

    private UpdateChecker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static CheckResult getLastCheckResult() {
        return lastCheckResult;
    }

    public static enum CheckResult {
        API_ERROR("api-error"),
        OUTDATED_VERSION("outdated-version"),
        UNSTABLE_VERSION("unstable-version"),
        LATEST_VERSION(null),
        UNRESOLVED(null);

        private final String configKey;

        public String getConfigKey() {
            return this.configKey;
        }

        private CheckResult(String configKey) {
            this.configKey = configKey;
        }
    }
}

