/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol;

import java.io.File;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.config.SonarConfiguration;
import xyz.jonesdev.sonar.api.event.impl.CaptchaGenerationStartEvent;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.captcha.StandardCaptchaGenerator;
import xyz.jonesdev.sonar.captcha.legacy.LegacyCaptchaGenerator;
import xyz.jonesdev.sonar.common.fallback.protocol.CaptchaPreparer;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketRegistry;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketSnapshot;
import xyz.jonesdev.sonar.common.fallback.protocol.block.BlockType;
import xyz.jonesdev.sonar.common.fallback.protocol.block.BlockUpdate;
import xyz.jonesdev.sonar.common.fallback.protocol.dimension.DimensionRegistry;
import xyz.jonesdev.sonar.common.fallback.protocol.dimension.DimensionType;
import xyz.jonesdev.sonar.common.fallback.protocol.entity.EntityType;
import xyz.jonesdev.sonar.common.fallback.protocol.item.ItemType;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.configuration.RegistryDataPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.login.LoginSuccessPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.ChunkDataPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.DisconnectPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.GameEventPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.JoinGamePacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.KeepAlivePacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.PlayerAbilitiesPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.RemoveEntitiesPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetContainerSlotPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetDefaultSpawnPositionPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetExperiencePacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetHeldItemPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetPassengersPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetPlayerPositionRotationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SpawnEntityPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SystemChatPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.TransferPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.UpdateSectionBlocksPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.UpdateTimePacket;
import xyz.jonesdev.sonar.common.util.ComponentHolder;

public final class FallbackPreparer {
    private static final Random RANDOM = new Random();
    public static final int PLAYER_ENTITY_ID = RANDOM.nextInt();
    public static final int VEHICLE_ENTITY_ID = RANDOM.nextInt();
    public static final BlockType[] POSSIBLE_BLOCK_TYPES = BlockType.values();
    public static final FallbackPacket[] BLOCKS_PACKETS = new FallbackPacket[POSSIBLE_BLOCK_TYPES.length];
    public static final int BLOCKS_PER_ROW = 8;
    public static final int SPAWN_X_POSITION = 8;
    public static final int SPAWN_Z_POSITION = 8;
    public static final int PLATFORM_Y_POSITION = 1 + RANDOM.nextInt(255);
    public static final int IN_AIR_Y_POSITION = 3000 + RANDOM.nextInt(500);
    public static final int FIRST_TELEPORT_ID = RANDOM.nextInt();
    public static final int SECOND_TELEPORT_ID = RANDOM.nextInt();
    public static final int PRE_JOIN_KEEP_ALIVE_ID = RANDOM.nextInt();
    private static final int MAP_SLOT = RANDOM.nextInt(9);
    public static final FallbackPacket CAPTCHA_SET_CONTAINER_SLOT = new SetContainerSlotPacket(0, 36 + MAP_SLOT, 1, ItemType.FILLED_MAP, ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("map", (BinaryTag)IntBinaryTag.intBinaryTag((int)0))).build());
    public static final FallbackPacket CAPTCHA_HELD_ITEM_SLOT = new SetHeldItemPacket(MAP_SLOT);
    public static final FallbackPacket DEFAULT_ABILITIES = new PlayerAbilitiesPacket(0, 0.0f, 0.0f);
    public static final FallbackPacket NO_MOVE_ABILITIES = new PlayerAbilitiesPacket(2, 0.0f, 0.0f);
    public static final FallbackPacket NO_MOVE_ABILITIES_BEDROCK = new PlayerAbilitiesPacket(6, 0.0f, 0.0f);
    public static final FallbackPacket CAPTCHA_POSITION = new FallbackPacketSnapshot(new SetPlayerPositionRotationPacket(8.0, 10000.0, 8.0, 0.0f, 90.0f, 0, 0, false, false, true));
    public static final FallbackPacket[] EMPTY_CHUNK_DATA = new FallbackPacket[]{new FallbackPacketSnapshot(new ChunkDataPacket(0, 0)), new FallbackPacketSnapshot(new ChunkDataPacket(0, 1)), new FallbackPacketSnapshot(new ChunkDataPacket(0, -1)), new FallbackPacketSnapshot(new ChunkDataPacket(1, 0)), new FallbackPacketSnapshot(new ChunkDataPacket(1, 1)), new FallbackPacketSnapshot(new ChunkDataPacket(1, -1)), new FallbackPacketSnapshot(new ChunkDataPacket(-1, 0)), new FallbackPacketSnapshot(new ChunkDataPacket(-1, 1)), new FallbackPacketSnapshot(new ChunkDataPacket(-1, -1))};
    public static final FallbackPacket PRE_JOIN_KEEP_ALIVE = new FallbackPacketSnapshot(new KeepAlivePacket(PRE_JOIN_KEEP_ALIVE_ID));
    public static final FallbackPacket[] REGISTRY_SYNC_1_20 = new FallbackPacket[]{new FallbackPacketSnapshot(new RegistryDataPacket(DimensionRegistry.CODEC_1_20, null, null))};
    public static final FallbackPacket[] REGISTRY_SYNC_1_20_5 = RegistryDataPacket.of(DimensionRegistry.CODEC_1_20_5);
    public static final FallbackPacket[] REGISTRY_SYNC_1_21 = RegistryDataPacket.of(DimensionRegistry.CODEC_1_21);
    public static final FallbackPacket[] REGISTRY_SYNC_1_21_2 = RegistryDataPacket.of(DimensionRegistry.CODEC_1_21_2);
    public static final FallbackPacket[] REGISTRY_SYNC_1_21_4 = RegistryDataPacket.of(DimensionRegistry.CODEC_1_21_4);
    public static final FallbackPacket[] REGISTRY_SYNC_1_21_5 = RegistryDataPacket.of(DimensionRegistry.CODEC_1_21_5);
    public static final FallbackPacket START_WRITING_CHUNKS = new GameEventPacket(13, 0.0f);
    public static final FallbackPacket INVALID_HELD_ITEM_SLOT = new SetHeldItemPacket(-1);
    public static final FallbackPacket RANDOM_KEEP_ALIVE = new FallbackPacketSnapshot(new KeepAlivePacket(RANDOM.nextInt()));
    public static final FallbackPacket SPAWN_BOAT_ENTITY = new FallbackPacketSnapshot(new SpawnEntityPacket(VEHICLE_ENTITY_ID, EntityType.BOAT, 8.0, IN_AIR_Y_POSITION, 8.0, 0, 0.0, 0.0, 0.0));
    public static final FallbackPacket SPAWN_MINECART_ENTITY = new FallbackPacketSnapshot(new SpawnEntityPacket(VEHICLE_ENTITY_ID, EntityType.MINECART, 8.0, IN_AIR_Y_POSITION - 16, 8.0, 0, 0.0, 0.0, 0.0));
    public static final FallbackPacket REMOVE_VEHICLE = new RemoveEntitiesPacket(VEHICLE_ENTITY_ID);
    public static final FallbackPacket SET_VEHICLE_PASSENGERS = new FallbackPacketSnapshot(new SetPassengersPacket(VEHICLE_ENTITY_ID, PLAYER_ENTITY_ID));
    public static FallbackPacket[] incorrectCaptcha;
    public static FallbackPacket loginSuccess;
    public static FallbackPacket welcomeMessage;
    public static FallbackPacket enterCodeMessage;
    public static FallbackPacket joinGame;
    public static FallbackPacket defaultSpawnPosition;
    public static FallbackPacket spawnPosition;
    public static FallbackPacket fallStartPosition;
    public static FallbackPacket fallStartPositionLegacy;
    public static FallbackPacket transferToOrigin;
    public static FallbackPacket blacklisted;
    public static FallbackPacket alreadyQueued;
    public static FallbackPacket alreadyVerifying;
    public static FallbackPacket reconnectedTooFast;
    public static FallbackPacket protocolBlacklisted;
    public static FallbackPacket unsupportedVersion;
    public static FallbackPacket tooManyOnlinePerIP;
    public static FallbackPacket[] xpCountdown;
    public static FallbackPacket updateTime;
    public static int maxMovementTick;
    public static int dynamicSpawnYPosition;
    public static int maxTotalPacketsSent;

    public static void prepare() {
        Sonar.get0().getLogger().info("Preloading all registered packets...", new Object[0]);
        FallbackPacketRegistry.values();
        UUID uuid = UUID.randomUUID();
        String username = Sonar.get0().getConfig().getGeneralConfig().getString("verification.cached-username");
        if (username.length() > 16) {
            username = username.substring(0, 16);
        }
        loginSuccess = new FallbackPacketSnapshot(new LoginSuccessPacket(uuid, username, true));
        joinGame = new FallbackPacketSnapshot(new JoinGamePacket(PLAYER_ENTITY_ID, Sonar.get0().getConfig().getVerification().getGamemode().getId(), -1, 0, 0, RANDOM.nextInt(3), 1, 0, 0, new String[]{"minecraft:overworld"}, "minecraft:overworld", "flat", DimensionType.OVERWORLD, RANDOM.nextLong() & 0x539L, false, true, false, false, false, false, true));
        maxMovementTick = Sonar.get0().getConfig().getVerification().getGravity().getMaxMovementTicks();
        double motionY = 0.0;
        double fallDistance = 0.0;
        for (int i = 0; i < maxMovementTick; ++i) {
            motionY = (motionY - 0.1) * (double)0.98f;
            fallDistance += Math.abs(motionY);
        }
        dynamicSpawnYPosition = PLATFORM_Y_POSITION + (int)Math.ceil(fallDistance);
        defaultSpawnPosition = new FallbackPacketSnapshot(new SetDefaultSpawnPositionPacket("minecraft:overworld", 8, IN_AIR_Y_POSITION, 8));
        spawnPosition = new FallbackPacketSnapshot(new SetPlayerPositionRotationPacket(8.0, IN_AIR_Y_POSITION, 8.0, 0.0f, 0.0f, FIRST_TELEPORT_ID, 0, false, false, true));
        fallStartPosition = new FallbackPacketSnapshot(new SetPlayerPositionRotationPacket(8.0, dynamicSpawnYPosition - IN_AIR_Y_POSITION, 8.0, 0.0f, -90.0f, SECOND_TELEPORT_ID, 2, false, false, true));
        fallStartPositionLegacy = new FallbackPacketSnapshot(new SetPlayerPositionRotationPacket(8.0, dynamicSpawnYPosition, 8.0, 0.0f, -90.0f, 0, 0, false, false, true));
        int length = 4;
        for (int i = 0; i < BLOCKS_PACKETS.length; ++i) {
            BlockUpdate[] blocks = new BlockUpdate[64];
            int index = 0;
            for (int x = 0; x < 8; ++x) {
                for (int z = 0; z < 8; ++z) {
                    BlockUpdate.BlockPosition position = new BlockUpdate.BlockPosition(x + 4, PLATFORM_Y_POSITION, z + 4, 0, 0);
                    blocks[index++] = new BlockUpdate(position, POSSIBLE_BLOCK_TYPES[i]);
                }
            }
            FallbackPreparer.BLOCKS_PACKETS[i] = new FallbackPacketSnapshot(new UpdateSectionBlocksPacket(0, 0, blocks));
        }
        blacklisted = new FallbackPacketSnapshot(new DisconnectPacket(Sonar.get0().getConfig().getVerification().getBlacklisted(), true));
        alreadyVerifying = new FallbackPacketSnapshot(new DisconnectPacket(Sonar.get0().getConfig().getVerification().getAlreadyVerifying(), true));
        alreadyQueued = new FallbackPacketSnapshot(new DisconnectPacket(Sonar.get0().getConfig().getVerification().getAlreadyQueued(), true));
        protocolBlacklisted = new FallbackPacketSnapshot(new DisconnectPacket(Sonar.get0().getConfig().getVerification().getProtocolBlacklisted(), true));
        reconnectedTooFast = new FallbackPacketSnapshot(new DisconnectPacket(Sonar.get0().getConfig().getVerification().getTooFastReconnect(), true));
        unsupportedVersion = new FallbackPacketSnapshot(new DisconnectPacket(Sonar.get0().getConfig().getVerification().getUnsupportedVersion(), true));
        tooManyOnlinePerIP = new FallbackPacketSnapshot(new DisconnectPacket(Sonar.get0().getConfig().getTooManyOnlinePerIp(), true));
        transferToOrigin = Sonar.get0().getConfig().getGeneralConfig().getBoolean("verification.transfer.enabled") ? new FallbackPacketSnapshot(new TransferPacket(Sonar.get0().getConfig().getGeneralConfig().getString("verification.transfer.destination-host"), Sonar.get0().getConfig().getGeneralConfig().getInt("verification.transfer.destination-port"))) : null;
        int timeOfDay = Sonar.get0().getConfig().getVerification().getTimeOfDay();
        updateTime = timeOfDay != 1000 ? new UpdateTimePacket(0L, timeOfDay, false) : null;
        String welcome = Sonar.get0().getConfig().getMessagesConfig().getString("verification.welcome");
        welcomeMessage = welcome.isEmpty() ? null : new FallbackPacketSnapshot(new SystemChatPacket(new ComponentHolder(MiniMessage.miniMessage().deserialize(welcome, (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())))));
        if (Sonar.get0().getConfig().getVerification().getMap().getTiming() != SonarConfiguration.Verification.Timing.NEVER || Sonar.get0().getConfig().getVerification().getGravity().isCaptchaOnFail()) {
            int i;
            enterCodeMessage = new FallbackPacketSnapshot(new SystemChatPacket(new ComponentHolder(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("verification.captcha.enter"), (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())))));
            incorrectCaptcha = new FallbackPacket[Sonar.get0().getConfig().getVerification().getMap().getMaxTries()];
            for (i = 0; i < incorrectCaptcha.length; ++i) {
                FallbackPreparer.incorrectCaptcha[i] = new FallbackPacketSnapshot(new SystemChatPacket(new ComponentHolder(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("verification.captcha.incorrect"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"attempts-left", (String)String.valueOf(i + 1))}))));
            }
            xpCountdown = new FallbackPacket[Sonar.get0().getConfig().getVerification().getMap().getMaxDuration() / 1000];
            for (i = 0; i < xpCountdown.length; ++i) {
                float bar = (float)i / (float)xpCountdown.length;
                FallbackPreparer.xpCountdown[i] = new FallbackPacketSnapshot(new SetExperiencePacket(bar, i, 0));
            }
            CaptchaGenerationStartEvent generationStartEvent = new CaptchaGenerationStartEvent(Sonar.get0().getFallback().getCaptchaGenerator());
            Sonar.get0().getEventManager().publish(generationStartEvent);
            if (generationStartEvent.getCaptchaGenerator() == null || generationStartEvent.getCaptchaGenerator() instanceof StandardCaptchaGenerator || generationStartEvent.getCaptchaGenerator() instanceof LegacyCaptchaGenerator) {
                File backgroundImage = Sonar.get0().getConfig().getVerification().getMap().getBackgroundImage();
                boolean useLegacyCaptchaGenerator = Sonar.get0().getConfig().getGeneralConfig().getString("verification.checks.map-captcha.style").equalsIgnoreCase("legacy");
                Sonar.get0().getFallback().setCaptchaGenerator(useLegacyCaptchaGenerator ? new LegacyCaptchaGenerator(backgroundImage) : new StandardCaptchaGenerator(backgroundImage));
            } else {
                Sonar.get0().getLogger().info("Custom CAPTCHA generator detected, skipping reinitialization.", new Object[0]);
            }
            CaptchaPreparer.prepare();
        } else {
            enterCodeMessage = null;
            incorrectCaptcha = null;
            xpCountdown = null;
            Sonar.get0().getFallback().setCaptchaGenerator(null);
        }
        maxTotalPacketsSent = maxMovementTick + 2 + (xpCountdown == null ? 0 : xpCountdown.length) * 20 + 5 + Sonar.get0().getConfig().getVerification().getVehicle().getMinimumPackets() * 4 + Sonar.get0().getConfig().getVerification().getMap().getMaxTries() + Sonar.get0().getConfig().getVerification().getMaxPacketCount();
    }

    public static FallbackPacket[] getRegistryPackets(@NotNull ProtocolVersion protocolVersion) {
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_5)) {
            return REGISTRY_SYNC_1_21_5;
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_4)) {
            return REGISTRY_SYNC_1_21_4;
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2)) {
            return REGISTRY_SYNC_1_21_2;
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21)) {
            return REGISTRY_SYNC_1_21;
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20_5)) {
            return REGISTRY_SYNC_1_20_5;
        }
        return REGISTRY_SYNC_1_20;
    }

    private FallbackPreparer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

