/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.map;

import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.FallbackUser;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.MapDataPacket;

public final class MapCaptchaInfo {
    private final String answer;
    private final FallbackPacket[] legacy;
    private final FallbackPacket modern;

    public MapCaptchaInfo(@NotNull String answer, byte @NotNull [] buffer) {
        int i;
        this.answer = answer;
        byte[][] grid = new byte[128][128];
        for (i = 0; i < buffer.length; ++i) {
            grid[i & 0x7F][i >> 7] = buffer[i];
        }
        this.legacy = new FallbackPacket[grid.length];
        for (i = 0; i < grid.length; ++i) {
            this.legacy[i] = new MapDataPacket(grid[i], i, 0, 0, true);
        }
        this.modern = new MapDataPacket(buffer, 0, 0, 0, true);
    }

    public void delayedWrite(@NotNull FallbackUser user) {
        if (user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            for (FallbackPacket packet : this.legacy) {
                user.delayedWrite(packet);
            }
            return;
        }
        user.delayedWrite(this.modern);
    }

    public String getAnswer() {
        return this.answer;
    }

    public FallbackPacket[] getLegacy() {
        return this.legacy;
    }

    public FallbackPacket getModern() {
        return this.modern;
    }
}

