/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.configuration;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketSnapshot;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class RegistryDataPacket
implements FallbackPacket {
    private CompoundBinaryTag tag;
    private String type;
    private List<Bundle> bundles;

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
            ProtocolUtil.writeBinaryTag(byteBuf, protocolVersion, this.tag);
        } else if (this.type != null) {
            ProtocolUtil.writeString(byteBuf, this.type);
            ProtocolUtil.writeVarInt(byteBuf, this.bundles.size());
            for (Bundle bundle : this.bundles) {
                ProtocolUtil.writeString(byteBuf, bundle.getName());
                CompoundBinaryTag tag = bundle.getTag();
                if (tag != null) {
                    byteBuf.writeBoolean(true);
                    ProtocolUtil.writeBinaryTag(byteBuf, protocolVersion, tag);
                    continue;
                }
                byteBuf.writeBoolean(false);
            }
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public static FallbackPacket @NotNull [] of(@NotNull CompoundBinaryTag rootTag) {
        FallbackPacket[] packets = new FallbackPacket[rootTag.size()];
        int index = 0;
        for (String type : rootTag.keySet()) {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            for (BinaryTag binaryTag : rootTag.getCompound(type).getList("value")) {
                CompoundBinaryTag tag = (CompoundBinaryTag)binaryTag;
                bundles.add(new Bundle(tag.getString("name"), tag.get("element") == null ? null : tag.getCompound("element")));
            }
            packets[index++] = new FallbackPacketSnapshot(new RegistryDataPacket(rootTag, type, bundles));
        }
        return packets;
    }

    public CompoundBinaryTag getTag() {
        return this.tag;
    }

    public String getType() {
        return this.type;
    }

    public List<Bundle> getBundles() {
        return this.bundles;
    }

    public RegistryDataPacket() {
    }

    public RegistryDataPacket(CompoundBinaryTag tag, String type, List<Bundle> bundles) {
        this.tag = tag;
        this.type = type;
        this.bundles = bundles;
    }

    public static final class Bundle {
        @NotNull
        private final String name;
        @Nullable
        private final CompoundBinaryTag tag;

        public Bundle(@NotNull String name, @Nullable CompoundBinaryTag tag) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.tag = tag;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public CompoundBinaryTag getTag() {
            return this.tag;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bundle)) {
                return false;
            }
            Bundle other = (Bundle)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            CompoundBinaryTag this$tag = this.getTag();
            CompoundBinaryTag other$tag = other.getTag();
            return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            CompoundBinaryTag $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            return result;
        }

        public String toString() {
            return "RegistryDataPacket.Bundle(name=" + this.getName() + ", tag=" + String.valueOf(this.getTag()) + ")";
        }
    }
}

