/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;

public final class PlayerInputPacket
implements FallbackPacket {
    private float sideways;
    private float forward;
    private boolean jump;
    private boolean sneak;

    @Override
    public void encode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2)) {
            byte mask = byteBuf.readByte();
            this.jump = (mask & 0x10) != 0;
            this.sneak = (mask & 0x20) != 0;
            return;
        }
        this.sideways = byteBuf.readFloat();
        this.forward = byteBuf.readFloat();
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.jump = byteBuf.readBoolean();
            this.sneak = byteBuf.readBoolean();
        } else {
            byte flags = byteBuf.readByte();
            this.jump = (flags & 1) != 0;
            this.sneak = (flags & 2) != 0;
        }
    }

    public float getSideways() {
        return this.sideways;
    }

    public float getForward() {
        return this.forward;
    }

    public boolean isJump() {
        return this.jump;
    }

    public boolean isSneak() {
        return this.sneak;
    }

    public String toString() {
        return "PlayerInputPacket(sideways=" + this.getSideways() + ", forward=" + this.getForward() + ", jump=" + this.isJump() + ", sneak=" + this.isSneak() + ")";
    }

    public PlayerInputPacket() {
    }

    public PlayerInputPacket(float sideways, float forward, boolean jump, boolean sneak) {
        this.sideways = sideways;
        this.forward = forward;
        this.jump = jump;
        this.sneak = sneak;
    }
}

