/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;

public final class SetPlayerPositionPacket
implements FallbackPacket {
    private double x;
    private double y;
    private double z;
    private boolean onGround;
    private boolean horizontalCollision;

    @Override
    public void encode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        this.x = byteBuf.readDouble();
        this.y = byteBuf.readDouble();
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.readDouble();
        }
        this.z = byteBuf.readDouble();
        if (protocolVersion.greaterThan(ProtocolVersion.MINECRAFT_1_21_2)) {
            short flag = byteBuf.readUnsignedByte();
            this.onGround = (flag & 1) != 0;
            this.horizontalCollision = (flag & 2) != 0;
        } else {
            this.onGround = byteBuf.readBoolean();
        }
    }

    @Override
    public int expectedMaxLength(@NotNull ProtocolVersion protocolVersion) {
        return protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8) ? 33 : 25;
    }

    @Override
    public int expectedMinLength(ProtocolVersion protocolVersion) {
        return 25;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isHorizontalCollision() {
        return this.horizontalCollision;
    }

    public String toString() {
        return "SetPlayerPositionPacket(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", onGround=" + this.isOnGround() + ", horizontalCollision=" + this.isHorizontalCollision() + ")";
    }

    public SetPlayerPositionPacket() {
    }

    public SetPlayerPositionPacket(double x, double y, double z, boolean onGround, boolean horizontalCollision) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.onGround = onGround;
        this.horizontalCollision = horizontalCollision;
    }
}

