/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;

public final class SetPlayerRotationPacket
implements FallbackPacket {
    private float yaw;
    private float pitch;
    private boolean onGround;
    private boolean horizontalCollision;

    @Override
    public void encode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        this.yaw = byteBuf.readFloat();
        this.pitch = byteBuf.readFloat();
        if (protocolVersion.greaterThan(ProtocolVersion.MINECRAFT_1_21_2)) {
            short flag = byteBuf.readUnsignedByte();
            this.onGround = (flag & 1) != 0;
            this.horizontalCollision = (flag & 2) != 0;
        } else {
            this.onGround = byteBuf.readBoolean();
        }
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isHorizontalCollision() {
        return this.horizontalCollision;
    }

    public String toString() {
        return "SetPlayerRotationPacket(yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", onGround=" + this.isOnGround() + ", horizontalCollision=" + this.isHorizontalCollision() + ")";
    }

    public SetPlayerRotationPacket() {
    }

    public SetPlayerRotationPacket(float yaw, float pitch, boolean onGround, boolean horizontalCollision) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.onGround = onGround;
        this.horizontalCollision = horizontalCollision;
    }
}

