/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class TransferPacket
implements FallbackPacket {
    private String destinationHost;
    private int destinationPort;

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        ProtocolUtil.writeString(byteBuf, this.destinationHost);
        ProtocolUtil.writeVarInt(byteBuf, this.destinationPort);
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public String getDestinationHost() {
        return this.destinationHost;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public String toString() {
        return "TransferPacket(destinationHost=" + this.getDestinationHost() + ", destinationPort=" + this.getDestinationPort() + ")";
    }

    public TransferPacket() {
    }

    public TransferPacket(String destinationHost, int destinationPort) {
        this.destinationHost = destinationHost;
        this.destinationPort = destinationPort;
    }
}

