/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.verification;

import java.util.Random;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.database.model.VerifiedPlayer;
import xyz.jonesdev.sonar.api.event.impl.UserBlacklistedEvent;
import xyz.jonesdev.sonar.api.event.impl.UserVerifyFailedEvent;
import xyz.jonesdev.sonar.api.event.impl.UserVerifySuccessEvent;
import xyz.jonesdev.sonar.api.fallback.FallbackUser;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.netty.FallbackVarInt21FrameDecoder;
import xyz.jonesdev.sonar.common.fallback.netty.FallbackVarIntLengthEncoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketDecoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketEncoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketListener;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.statistics.GlobalSonarStatistics;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public abstract class FallbackVerificationHandler
implements FallbackPacketListener {
    protected final FallbackUser user;
    protected static final Random RANDOM = new Random();

    protected final void finishVerification() {
        ++GlobalSonarStatistics.totalSuccessfulVerifications;
        Sonar.get0().getVerifiedPlayerController().add(new VerifiedPlayer(this.user.getFingerprint(), this.user.getLoginTimer().getStart()));
        Sonar.get0().getEventManager().publish(new UserVerifySuccessEvent(this.user));
        if (FallbackPreparer.transferToOrigin != null && this.user.getProtocolVersion().greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20_5)) {
            if (this.user.isGeyser()) {
                this.user.write(FallbackPreparer.transferToOrigin);
                this.user.channel().pipeline().remove(FallbackPacketDecoder.class);
                this.user.channel().pipeline().remove(FallbackPacketEncoder.class);
                this.user.channel().pipeline().remove(FallbackVarInt21FrameDecoder.class);
                this.user.channel().pipeline().remove(FallbackVarIntLengthEncoder.class);
            } else {
                ProtocolUtil.closeWith(this.user.channel(), this.user.getProtocolVersion(), FallbackPreparer.transferToOrigin);
            }
        } else {
            this.user.disconnect(Sonar.get0().getConfig().getVerification().getVerificationSuccess());
        }
        Sonar.get0().getLogger().info(Sonar.get0().getConfig().getMessagesConfig().getString("verification.logs.successful").replace("<username>", this.user.getUsername()).replace("<time-taken>", this.user.getLoginTimer().toString()), new Object[0]);
    }

    protected final void fail(@NotNull String reason) {
        boolean shouldLog;
        ++GlobalSonarStatistics.totalFailedVerifications;
        this.user.disconnect(Sonar.get0().getConfig().getVerification().getVerificationFailed());
        boolean bl = shouldLog = Sonar.get0().getAttackTracker().getCurrentAttack() == null || Sonar.get0().getConfig().getVerification().isLogDuringAttack();
        if (shouldLog) {
            Sonar.get0().getLogger().info(Sonar.get0().getConfig().getMessagesConfig().getString("verification.logs.failed").replace("<username>", this.user.getUsername()).replace("<ip>", Sonar.get0().getConfig().formatAddress(this.user.getInetAddress())).replace("<protocol>", this.user.getProtocolVersion().getName()).replace("<reason>", reason), new Object[0]);
        }
        Sonar.get0().getEventManager().publish(new UserVerifyFailedEvent(this.user, reason));
        String hostAddress = this.user.getInetAddress().getHostAddress();
        int score = (Integer)Sonar.get0().getFallback().getBlacklist().get((Object)hostAddress, __ -> 0);
        int newScore = score + 1;
        Sonar.get0().getFallback().getBlacklist().put((Object)hostAddress, (Object)newScore);
        int limit = Sonar.get0().getConfig().getVerification().getBlacklistThreshold();
        if (newScore >= limit) {
            ++GlobalSonarStatistics.totalBlacklistedPlayers;
            Sonar.get0().getEventManager().publish(new UserBlacklistedEvent(this.user));
            if (shouldLog) {
                Sonar.get0().getLogger().info(Sonar.get0().getConfig().getMessagesConfig().getString("verification.logs.blacklisted").replace("<username>", this.user.getUsername()).replace("<ip>", Sonar.get0().getConfig().formatAddress(this.user.getInetAddress())).replace("<protocol>", this.user.getProtocolVersion().getName()), new Object[0]);
            }
        }
        throw QuietDecoderException.INSTANCE;
    }

    protected final void checkState(boolean state, String failReason) {
        if (!state) {
            this.fail(failReason);
        }
    }

    public FallbackVerificationHandler(FallbackUser user) {
        this.user = user;
    }
}

