/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.subcommand;

import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.command.InvocationSource;
import xyz.jonesdev.sonar.api.command.subcommand.Subcommand;
import xyz.jonesdev.sonar.api.command.subcommand.SubcommandInfo;

@SubcommandInfo(name="blacklist", arguments={"add", "remove", "clear", "size"})
public final class BlacklistCommand
extends Subcommand {
    @Override
    protected void execute(@NotNull InvocationSource source, String @NotNull [] args) {
        switch (args[1].toLowerCase()) {
            case "add": {
                if (args.length <= 2) {
                    this.incorrectUsage(source, "blacklist add <IP address>");
                    return;
                }
                String rawAddress = BlacklistCommand.validateIP(source, args[2]);
                if (rawAddress == null) {
                    return;
                }
                if (Sonar.get0().getFallback().getBlacklist().asMap().containsKey(rawAddress)) {
                    source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.blacklist.ip-duplicate"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"ip", (String)rawAddress)}));
                    return;
                }
                Sonar.get0().getFallback().getBlacklist().put((Object)rawAddress, (Object)1337);
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.blacklist.add"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"ip", (String)rawAddress)}));
                break;
            }
            case "remove": {
                if (args.length <= 2) {
                    this.incorrectUsage(source, "blacklist remove <IP address>");
                    return;
                }
                String rawAddress = BlacklistCommand.validateIP(source, args[2]);
                if (rawAddress == null) {
                    return;
                }
                if (!Sonar.get0().getFallback().getBlacklist().asMap().containsKey(rawAddress)) {
                    source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.blacklist.ip-not-found"), (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())));
                    return;
                }
                Sonar.get0().getFallback().getBlacklist().invalidate((Object)rawAddress);
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.blacklist.remove"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"ip", (String)rawAddress)}));
                break;
            }
            case "clear": {
                long blacklistSize = Sonar.get0().getFallback().getBlacklist().estimatedSize();
                if (blacklistSize == 0L) {
                    source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.blacklist.empty"), (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())));
                    return;
                }
                Sonar.get0().getFallback().getBlacklist().invalidateAll();
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.blacklist.clear"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"amount", (String)Sonar.DECIMAL_FORMAT.format(blacklistSize))}));
                break;
            }
            case "size": {
                long blacklistSize = Sonar.get0().getFallback().getBlacklist().estimatedSize();
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.blacklist.size"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"amount", (String)Sonar.DECIMAL_FORMAT.format(blacklistSize))}));
                break;
            }
            default: {
                this.incorrectUsage(source);
            }
        }
    }
}

