/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.subcommand;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.command.InvocationSource;
import xyz.jonesdev.sonar.api.command.subcommand.Subcommand;
import xyz.jonesdev.sonar.api.command.subcommand.SubcommandInfo;
import xyz.jonesdev.sonar.api.profiler.SimpleProcessProfiler;

@SubcommandInfo(name="statistics", aliases={"stats"}, arguments={"network", "memory", "cpu"}, argumentsRequired=false)
public final class StatisticsCommand
extends Subcommand {
    @Override
    protected void execute(@NotNull InvocationSource source, String @NotNull [] args) {
        String type = "general";
        if (args.length >= 2) {
            try {
                type = args[1].toLowerCase();
            }
            catch (Exception exception) {
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.statistics.unknown-type"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"statistics", (String)this.getArguments())}));
                return;
            }
        }
        source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.statistics.header"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"statistics-type", (String)type)}));
        source.sendMessage((Component)Component.empty());
        TagResolver.Single[] placeholders = null;
        switch (type) {
            case "general": {
                long seconds = Sonar.get0().getLaunchTimer().delay() / 1000L;
                long days = seconds / 86400L;
                long hours = seconds % 86400L / 3600L;
                long minutes = seconds % 3600L / 60L;
                String serverUptime = String.format("%dd %dh %dm %ds", days, hours, minutes, seconds % 60L);
                placeholders = new TagResolver.Single[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"verified", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getVerifiedPlayerController().getCache().size())), Placeholder.unparsed((String)"verifying", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getFallback().getConnected().size())), Placeholder.unparsed((String)"blacklisted", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getFallback().getBlacklist().estimatedSize())), Placeholder.unparsed((String)"queued", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getFallback().getQueue().getPlayers().size())), Placeholder.unparsed((String)"server-uptime", (String)serverUptime), Placeholder.unparsed((String)"total-joins", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalPlayersJoined())), Placeholder.unparsed((String)"total-attempts", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalAttemptedVerifications())), Placeholder.unparsed((String)"total-failed", (String)Sonar.DECIMAL_FORMAT.format(Sonar.get0().getStatistics().getTotalFailedVerifications()))};
                break;
            }
            case "cpu": {
                placeholders = new TagResolver.Single[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"process-cpu", (String)Sonar.DECIMAL_FORMAT.format(SimpleProcessProfiler.getProcessCPUUsage())), Placeholder.unparsed((String)"system-cpu", (String)Sonar.DECIMAL_FORMAT.format(SimpleProcessProfiler.getSystemCPUUsage())), Placeholder.unparsed((String)"average-process-cpu", (String)Sonar.DECIMAL_FORMAT.format(SimpleProcessProfiler.getAverageProcessCPUUsage())), Placeholder.unparsed((String)"average-system-cpu", (String)Sonar.DECIMAL_FORMAT.format(SimpleProcessProfiler.getAverageSystemCPUUsage())), Placeholder.unparsed((String)"virtual-core-count", (String)Sonar.DECIMAL_FORMAT.format(SimpleProcessProfiler.getVirtualCores()))};
                break;
            }
            case "memory": {
                placeholders = new TagResolver.Single[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"free-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getFreeMemory())), Placeholder.unparsed((String)"used-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getUsedMemory())), Placeholder.unparsed((String)"max-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getMaxMemory())), Placeholder.unparsed((String)"total-memory", (String)SimpleProcessProfiler.formatMemory(SimpleProcessProfiler.getTotalMemory()))};
                break;
            }
            case "network": {
                placeholders = new TagResolver.Single[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"incoming-traffic", (String)Sonar.get0().getStatistics().getPerSecondIncomingBandwidthFormatted()), Placeholder.unparsed((String)"outgoing-traffic", (String)Sonar.get0().getStatistics().getPerSecondOutgoingBandwidthFormatted()), Placeholder.unparsed((String)"incoming-traffic-ttl", (String)SimpleProcessProfiler.formatMemory(Sonar.get0().getStatistics().getTotalIncomingBandwidth())), Placeholder.unparsed((String)"outgoing-traffic-ttl", (String)SimpleProcessProfiler.formatMemory(Sonar.get0().getStatistics().getTotalOutgoingBandwidth()))};
            }
        }
        List<String> parts = Sonar.get0().getConfig().getMessagesConfig().getStringList("commands.statistics." + type);
        for (String msg : parts) {
            source.sendMessage(MiniMessage.miniMessage().deserialize(msg, placeholders));
        }
    }
}

