/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.subcommand;

import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.command.InvocationSource;
import xyz.jonesdev.sonar.api.command.subcommand.Subcommand;
import xyz.jonesdev.sonar.api.command.subcommand.SubcommandInfo;
import xyz.jonesdev.sonar.api.database.model.VerifiedPlayer;
import xyz.jonesdev.sonar.api.fingerprint.FingerprintingUtil;

@SubcommandInfo(name="verified", arguments={"add", "remove", "clear", "size"})
public final class VerifiedCommand
extends Subcommand {
    @Override
    protected void execute(@NotNull InvocationSource source, String @NotNull [] args) {
        switch (args[1].toLowerCase()) {
            case "remove": {
                if (args.length <= 3) {
                    this.incorrectUsage(source, "verified remove <IP address> <username>");
                    return;
                }
                String hostAddress = VerifiedCommand.validateIP(source, args[2]);
                if (hostAddress == null) {
                    return;
                }
                String username = args[3];
                String fingerprint = FingerprintingUtil.getFingerprint(username, hostAddress);
                if (!Sonar.get0().getVerifiedPlayerController().getCache().contains(fingerprint)) {
                    source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.verified.ip-not-found"), (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())));
                    return;
                }
                Sonar.get0().getVerifiedPlayerController().remove(fingerprint);
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.verified.remove"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"ip", (String)hostAddress), Placeholder.unparsed((String)"username", (String)username)}));
                break;
            }
            case "add": {
                if (args.length <= 3) {
                    this.incorrectUsage(source, "verified add <IP address> <username>");
                    return;
                }
                String hostAddress = VerifiedCommand.validateIP(source, args[2]);
                if (hostAddress == null) {
                    return;
                }
                String username = args[3];
                String fingerprint = FingerprintingUtil.getFingerprint(username, hostAddress);
                if (Sonar.get0().getVerifiedPlayerController().getCache().contains(fingerprint)) {
                    source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.verified.already"), (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())));
                    return;
                }
                Sonar.get0().getVerifiedPlayerController().add(new VerifiedPlayer(fingerprint, System.currentTimeMillis()));
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.verified.add"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"ip", (String)hostAddress), Placeholder.unparsed((String)"username", (String)username)}));
                break;
            }
            case "clear": {
                int verifiedSize = Sonar.get0().getVerifiedPlayerController().getCache().size();
                if (verifiedSize == 0) {
                    source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.verified.empty"), (TagResolver)Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix())));
                    return;
                }
                Sonar.get0().getVerifiedPlayerController().clearAll();
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.verified.clear"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"amount", (String)Sonar.DECIMAL_FORMAT.format(verifiedSize))}));
                break;
            }
            case "size": {
                int verifiedSize = Sonar.get0().getVerifiedPlayerController().getCache().size();
                source.sendMessage(MiniMessage.miniMessage().deserialize(Sonar.get0().getConfig().getMessagesConfig().getString("commands.verified.size"), new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Sonar.get0().getConfig().getPrefix()), Placeholder.unparsed((String)"amount", (String)Sonar.DECIMAL_FORMAT.format(verifiedSize))}));
                break;
            }
            default: {
                this.incorrectUsage(source);
            }
        }
    }
}

