/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.Version;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public final class ProtocolUtil {
    public static final boolean DEBUG = Boolean.getBoolean("sonar.debug-traces");
    private static final int[] VAR_INT_LENGTHS = new int[65];

    public static int varIntBytes(int value) {
        return VAR_INT_LENGTHS[Integer.numberOfLeadingZeros(value)];
    }

    public static int readVarInt(@NotNull ByteBuf byteBuf) {
        int readable = byteBuf.readableBytes();
        if (readable == 0) {
            throw DEBUG ? new DecoderException("Empty buffer") : QuietDecoderException.INSTANCE;
        }
        byte k = byteBuf.readByte();
        if ((k & 0x80) != 128) {
            return k;
        }
        int maxRead = Math.min(5, readable);
        int i = k & 0x7F;
        for (int j = 1; j < maxRead; ++j) {
            k = byteBuf.readByte();
            i |= (k & 0x7F) << j * 7;
            if ((k & 0x80) == 128) continue;
            return i;
        }
        throw DEBUG ? new DecoderException("Bad VarInt") : QuietDecoderException.INSTANCE;
    }

    public static void writeVarInt(@NotNull ByteBuf byteBuf, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            byteBuf.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            byteBuf.writeShort(w);
        } else {
            ProtocolUtil.writeVarIntFull(byteBuf, value);
        }
    }

    private static void writeVarIntFull(@NotNull ByteBuf byteBuf, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            byteBuf.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            byteBuf.writeShort(w);
        } else if ((value & 0xFFE00000) == 0) {
            int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
            byteBuf.writeMedium(w);
        } else if ((value & 0xF0000000) == 0) {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21;
            byteBuf.writeInt(w);
        } else {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80);
            byteBuf.writeInt(w);
            byteBuf.writeByte(value >>> 28);
        }
    }

    public static void writeVarLong(@NotNull ByteBuf byteBuf, long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuf.writeByte((int)((byte)value));
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 8 | value >>> 7);
            byteBuf.writeShort(w);
        } else {
            ProtocolUtil.writeVarLongFull(byteBuf, value);
        }
    }

    private static void writeVarLongFull(@NotNull ByteBuf byteBuf, long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuf.writeByte((int)((byte)value));
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 8 | value >>> 7);
            byteBuf.writeShort(w);
        } else if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 16 | (value >>> 7 & 0x7FL | 0x80L) << 8 | value >>> 14);
            byteBuf.writeMedium(w);
        } else if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            int w = (int)((value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | value >>> 21);
            byteBuf.writeInt(w);
        } else {
            long l = (value & 0x7FL | 0x80L) << 24 | (value >>> 7 & 0x7FL | 0x80L) << 16 | (value >>> 14 & 0x7FL | 0x80L) << 8 | (value >>> 21 & 0x7FL | 0x80L);
            if ((value & 0xFFFFFFF800000000L) == 0L) {
                int w = (int)l;
                byteBuf.writeInt(w);
                byteBuf.writeByte((int)(value >>> 28));
            } else if ((value & 0xFFFFFC0000000000L) == 0L) {
                int w = (int)l;
                int w2 = (int)((value >>> 28 & 0x7FL | 0x80L) << 8 | value >>> 35);
                byteBuf.writeInt(w);
                byteBuf.writeShort(w2);
            } else if ((value & 0xFFFE000000000000L) == 0L) {
                int w = (int)l;
                int w2 = (int)((value >>> 28 & 0x7FL | 0x80L) << 16 | (value >>> 35 & 0x7FL | 0x80L) << 8 | value >>> 42);
                byteBuf.writeInt(w);
                byteBuf.writeMedium(w2);
            } else {
                long w = (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | value >>> 49;
                if ((value & 0xFF00000000000000L) == 0L) {
                    byteBuf.writeLong(w);
                } else if ((value & Long.MIN_VALUE) == 0L) {
                    byteBuf.writeLong(w);
                    byteBuf.writeByte((int)((byte)(value >>> 56)));
                } else {
                    int w2 = (int)((value >>> 56 & 0x7FL | 0x80L) << 8 | value >>> 63);
                    byteBuf.writeLong(w);
                    byteBuf.writeShort(w2);
                }
            }
        }
    }

    public static void checkNettyVersion() {
        Version version = Version.identify().getOrDefault("netty-all", (Version)Version.identify().get("netty-common"));
        if (version == null) {
            return;
        }
        String[] artifactVersion = version.artifactVersion().split("\\.");
        int major = Integer.parseInt(artifactVersion[0]);
        int minor = Integer.parseInt(artifactVersion[1]);
        if (major < 4 || major == 4 && minor < 1) {
            throw new IllegalStateException("Your Netty version is too old to run Sonar! Please use Netty >4.1.x.");
        }
    }

    public static void closeWith(@NotNull Channel channel, @NotNull ProtocolVersion protocolVersion, @NotNull Object msg) {
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            channel.eventLoop().execute(() -> {
                channel.config().setAutoRead(false);
                channel.eventLoop().schedule(() -> channel.writeAndFlush(msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE), 250L, TimeUnit.MILLISECONDS);
            });
        } else {
            channel.writeAndFlush(msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @NotNull
    public static UUID readUUID(@NotNull ByteBuf byteBuf) {
        return new UUID(byteBuf.readLong(), byteBuf.readLong());
    }

    public static byte @NotNull [] readByteArray(@NotNull ByteBuf byteBuf) {
        return ProtocolUtil.readByteArray(byteBuf, Short.MAX_VALUE);
    }

    public static byte @NotNull [] readByteArray(@NotNull ByteBuf byteBuf, int cap) {
        int length = ProtocolUtil.readVarInt(byteBuf);
        ProtocolUtil.checkState(length >= 0, "Got a negative-length array");
        ProtocolUtil.checkState(length <= cap, "Bad array size");
        ProtocolUtil.checkState(byteBuf.isReadable(length), "Trying to read an array that is too long");
        byte[] array = new byte[length];
        byteBuf.readBytes(array);
        return array;
    }

    @NotNull
    public static String readString(@NotNull ByteBuf byteBuf, int cap) throws DecoderException {
        int length = ProtocolUtil.readVarInt(byteBuf);
        return ProtocolUtil.readString(byteBuf, cap, length);
    }

    @NotNull
    private static String readString(@NotNull ByteBuf byteBuf, int cap, int length) throws DecoderException {
        ProtocolUtil.checkState(length >= 0, "Got a negative-length string");
        ProtocolUtil.checkState(length <= cap * 3, "Bad string size");
        ProtocolUtil.checkState(byteBuf.isReadable(length), "Tried to read a too-long string");
        String str = byteBuf.toString(byteBuf.readerIndex(), length, StandardCharsets.UTF_8);
        byteBuf.readerIndex(byteBuf.readerIndex() + length);
        ProtocolUtil.checkState(str.length() <= cap, "Got a too-long string");
        return str;
    }

    public static void writeString(@NotNull ByteBuf byteBuf, @NotNull CharSequence str) {
        int size = ByteBufUtil.utf8Bytes((CharSequence)str);
        ProtocolUtil.writeVarInt(byteBuf, size);
        byteBuf.writeCharSequence(str, StandardCharsets.UTF_8);
    }

    public static void writeUUID(@NotNull ByteBuf byteBuf, @NotNull UUID uuid) {
        byteBuf.writeLong(uuid.getMostSignificantBits());
        byteBuf.writeLong(uuid.getLeastSignificantBits());
    }

    public static void writeByteArray(@NotNull ByteBuf byteBuf, byte @NotNull [] bytes) {
        ProtocolUtil.writeVarInt(byteBuf, bytes.length);
        byteBuf.writeBytes(bytes);
    }

    public static void writeStringArray(@NotNull ByteBuf byteBuf, String @NotNull [] stringArray) {
        ProtocolUtil.writeVarInt(byteBuf, stringArray.length);
        for (String s : stringArray) {
            ProtocolUtil.writeString(byteBuf, s);
        }
    }

    public static <T extends BinaryTag> void writeBinaryTag(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion, @NotNull T tag) {
        BinaryTagType type = tag.type();
        byteBuf.writeByte((int)type.id());
        try {
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                byteBuf.writeShort(0);
            }
            type.write(tag, (DataOutput)new ByteBufOutputStream(byteBuf));
        }
        catch (IOException exception) {
            throw new EncoderException("Unable to encode BinaryTag", (Throwable)exception);
        }
    }

    public static int readExtendedForgeShort(@NotNull ByteBuf byteBuf) {
        int low = byteBuf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = byteBuf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    private static void checkState(boolean expression, String message) {
        if (!expression) {
            throw DEBUG ? new DecoderException(message) : QuietDecoderException.INSTANCE;
        }
    }

    private ProtocolUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            ProtocolUtil.VAR_INT_LENGTHS[i] = (int)Math.ceil((31.0 - (double)(i - 1)) / 7.0);
        }
        ProtocolUtil.VAR_INT_LENGTHS[32] = 1;
    }
}

