/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.velocity.fallback;

import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.protocol.packet.HandshakePacket;
import com.velocitypowered.proxy.protocol.packet.ServerLoginPacket;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.common.fallback.FallbackInboundHandlerAdapter;

final class FallbackVelocityInboundHandler
extends FallbackInboundHandlerAdapter {
    FallbackVelocityInboundHandler() {
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HandshakePacket) {
            HandshakePacket handshake = (HandshakePacket)msg;
            if (handshake.getNextStatus() == 1) {
                ctx.pipeline().remove((ChannelHandler)this);
            } else {
                this.handleHandshake(ctx, handshake.getServerAddress(), handshake.getProtocolVersion().getProtocol());
            }
        } else if (msg instanceof ServerLoginPacket) {
            ServerLoginPacket serverLogin = (ServerLoginPacket)msg;
            ctx.pipeline().remove((ChannelHandler)this);
            MinecraftConnection minecraftConnection = (MinecraftConnection)ctx.pipeline().get(MinecraftConnection.class);
            InetSocketAddress socketAddress = (InetSocketAddress)minecraftConnection.getRemoteAddress();
            this.handleLogin(ctx, () -> ctx.fireChannelRead(msg), serverLogin.getUsername(), socketAddress);
            return;
        }
        ctx.fireChannelRead(msg);
    }
}

