/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.api;

import java.text.DecimalFormat;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.SonarPlatform;
import xyz.jonesdev.sonar.api.SonarSupplier;
import xyz.jonesdev.sonar.api.SonarVersion;
import xyz.jonesdev.sonar.api.command.subcommand.SubcommandRegistry;
import xyz.jonesdev.sonar.api.config.SonarConfiguration;
import xyz.jonesdev.sonar.api.database.controller.VerifiedPlayerController;
import xyz.jonesdev.sonar.api.event.SonarEventManager;
import xyz.jonesdev.sonar.api.fallback.Fallback;
import xyz.jonesdev.sonar.api.logger.LoggerWrapper;
import xyz.jonesdev.sonar.api.notification.ActionBarNotificationHandler;
import xyz.jonesdev.sonar.api.notification.ChatNotificationHandler;
import xyz.jonesdev.sonar.api.statistics.SonarStatistics;
import xyz.jonesdev.sonar.api.timer.SystemTimer;
import xyz.jonesdev.sonar.api.tracker.AttackTracker;

public interface Sonar {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,###.##");

    @ApiStatus.Internal
    @Nullable
    public Audience audience(@Nullable UUID var1);

    @ApiStatus.Internal
    @NotNull
    public Audience sender(@NotNull Object var1);

    @NotNull
    public SonarPlatform getPlatform();

    @NotNull
    public LoggerWrapper getLogger();

    @NotNull
    public SonarConfiguration getConfig();

    @NotNull
    public SubcommandRegistry getSubcommandRegistry();

    public VerifiedPlayerController getVerifiedPlayerController();

    @NotNull
    public ActionBarNotificationHandler getActionBarNotificationHandler();

    @NotNull
    public ChatNotificationHandler getChatNotificationHandler();

    @NotNull
    public SystemTimer getLaunchTimer();

    @NotNull
    public SonarStatistics getStatistics();

    public void setActionBarNotificationHandler(@NotNull ActionBarNotificationHandler var1);

    public void setChatNotificationHandler(@NotNull ChatNotificationHandler var1);

    public void reload();

    @NotNull
    default public SonarVersion getVersion() {
        return SonarVersion.INSTANCE;
    }

    @NotNull
    default public SonarEventManager getEventManager() {
        return SonarEventManager.INSTANCE;
    }

    @NotNull
    default public AttackTracker getAttackTracker() {
        return AttackTracker.INSTANCE;
    }

    @NotNull
    default public Fallback getFallback() {
        return Fallback.INSTANCE;
    }

    @NotNull
    public static Sonar get() {
        return SonarSupplier.get();
    }

    @ApiStatus.Internal
    @NotNull
    public static Sonar get0() {
        return SonarSupplier.sonar;
    }
}

