/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.captcha.legacy;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.fallback.captcha.CaptchaGenerator;
import xyz.jonesdev.sonar.captcha.filters.NoiseOverlayFilter;
import xyz.jonesdev.sonar.captcha.legacy.RippleFilter;
import xyz.jonesdev.sonar.captcha.legacy.ScratchFilter;
import xyz.jonesdev.sonar.libs.jhlabs.image.BumpFilter;
import xyz.jonesdev.sonar.libs.jhlabs.image.CausticsFilter;
import xyz.jonesdev.sonar.libs.jhlabs.image.SaturationFilter;
import xyz.jonesdev.sonar.libs.jhlabs.image.SmearFilter;
import xyz.jonesdev.sonar.libs.jhlabs.image.UnsharpFilter;

public final class LegacyCaptchaGenerator
implements CaptchaGenerator {
    private static final ScratchFilter SCRATCHES = new ScratchFilter(4);
    private static final NoiseOverlayFilter NOISE = new NoiseOverlayFilter(1.0f, 7.0f);
    private static final SmearFilter SMEAR = new SmearFilter();
    private static final SaturationFilter SATURATION = new SaturationFilter();
    private static final RippleFilter RIPPLE = new RippleFilter();
    private static final Random RANDOM = new Random();
    private final int width = 128;
    private final int height = 128;
    @Nullable
    private final File background;
    @Nullable
    private BufferedImage backgroundImage;
    private GradientPaint gradient;

    public BufferedImage createCachedBackgroundImage() {
        BufferedImage image = new BufferedImage(128, 128, 5);
        if (this.background == null) {
            if (this.backgroundImage != null) {
                return this.backgroundImage;
            }
            image = new BufferedImage(128, 128, 1);
            image = new CausticsFilter().filter(image, null);
            SaturationFilter saturationFilter = new SaturationFilter();
            saturationFilter.setAmount(0.4f + RANDOM.nextFloat() * 0.2f);
            image = saturationFilter.filter(image, null);
            image = new UnsharpFilter().filter(image, null);
            return image;
        }
        if (this.backgroundImage == null) {
            try {
                this.backgroundImage = ImageIO.read(this.background);
            }
            catch (IOException exception) {
                throw new IllegalStateException("Could not read background image", exception);
            }
        }
        image.createGraphics().drawImage(this.backgroundImage, 0, 0, Color.WHITE, null);
        return image;
    }

    @NotNull
    private BufferedImage mergeImages(@NotNull BufferedImage background, @NotNull BufferedImage foreground) {
        BufferedImage image = new BufferedImage(128, 128, 5);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage((Image)background, 0, 0, null);
        graphics.setComposite(AlphaComposite.SrcOver);
        graphics.drawImage((Image)foreground, 0, 0, null);
        graphics.dispose();
        return image;
    }

    @Override
    @NotNull
    public BufferedImage createImage(char @NotNull [] answer) {
        Color color0 = Color.getHSBColor(RANDOM.nextFloat(), 1.0f, 1.0f);
        Color color1 = Color.getHSBColor(RANDOM.nextFloat(), 1.0f, 0.5f);
        this.gradient = new GradientPaint(0.0f, 0.0f, color0, 128.0f, 128.0f, color1);
        BufferedImage foreground = new BufferedImage(128, 128, 2);
        Graphics2D graphics = foreground.createGraphics();
        FontRenderContext ctx = graphics.getFontRenderContext();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawCharacters(graphics, ctx, answer);
        graphics.dispose();
        new BumpFilter().filter(foreground, foreground);
        SMEAR.filter(foreground, foreground);
        RIPPLE.filter(foreground, foreground);
        SCRATCHES.filter(foreground, foreground);
        BufferedImage merged = this.mergeImages(this.createCachedBackgroundImage(), foreground);
        NOISE.transform(merged);
        return merged;
    }

    private void drawCharacters(@NotNull Graphics2D graphics, @NotNull FontRenderContext ctx, char[] answer) {
        int fontSize = 62 - answer.length * 2;
        Font font = new Font("Monospaced", 0, fontSize);
        double stringWidth = font.getStringBounds(answer, 0, answer.length, ctx).getWidth();
        int beginX = (int)((128.0 - stringWidth) / 2.0 + stringWidth / ((double)answer.length * 2.5));
        int beginY = (int)((128.0 + (double)fontSize / 2.0) / 2.0);
        double rotation = 0.0;
        if (this.gradient != null) {
            graphics.setPaint(this.gradient);
        }
        for (char character : answer) {
            GlyphVector glyphVector = font.createGlyphVector(ctx, String.valueOf(character));
            int visualBoundsWidth = (int)glyphVector.getVisualBounds().getWidth();
            if (this.gradient == null) {
                Objects.requireNonNull(this.backgroundImage);
                int x0 = Math.min(Math.max(beginX + 5, 0), 128);
                int x1 = Math.min(Math.max(beginX + visualBoundsWidth, 0), 128);
                int y = beginY + fontSize / 2;
                Color color0 = new Color(~this.backgroundImage.getRGB(x0, y));
                Color color1 = new Color(~this.backgroundImage.getRGB(x1, y));
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, color0, 128.0f, 128.0f, color1);
                graphics.setPaint(gradient);
            }
            AffineTransform transformation = AffineTransform.getTranslateInstance(beginX, beginY);
            transformation.rotate(rotation += Math.toRadians(6 - RANDOM.nextInt(12)));
            transformation.scale(1.0, 1.25);
            Shape transformedShape = transformation.createTransformedShape(glyphVector.getOutline());
            graphics.fill(transformedShape);
            LegacyCaptchaGenerator.addTextOutline(graphics, transformedShape);
            beginX += visualBoundsWidth + 2;
        }
    }

    private static void addTextOutline(@NotNull Graphics2D graphics, @NotNull Shape transformedShape) {
        Shape strokedShape = new BasicStroke().createStrokedShape(transformedShape);
        double tx = 0.5 + RANDOM.nextDouble();
        double ty = 0.5 + RANDOM.nextDouble();
        AffineTransform transform = AffineTransform.getTranslateInstance(tx, ty);
        graphics.fill(transform.createTransformedShape(strokedShape));
    }

    public int getWidth() {
        Objects.requireNonNull(this);
        return 128;
    }

    public int getHeight() {
        Objects.requireNonNull(this);
        return 128;
    }

    @Nullable
    public File getBackground() {
        return this.background;
    }

    @Nullable
    public BufferedImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public GradientPaint getGradient() {
        return this.gradient;
    }

    public LegacyCaptchaGenerator(@Nullable File background) {
        this.background = background;
    }

    static {
        RIPPLE.setXAmplitude(0.0f);
        float yAmplitude = 10 - RANDOM.nextInt(20);
        if (Math.abs(yAmplitude) < 5.0f) {
            yAmplitude = yAmplitude >= 0.0f ? 5.0f : -5.0f;
        }
        RIPPLE.setYAmplitude(yAmplitude);
        SATURATION.setAmount(0.45f + RANDOM.nextFloat() * 0.15f);
        SMEAR.setShape(2);
        SMEAR.setMix(0.15f);
        SMEAR.setDensity(0.1f);
        SMEAR.setDistance(5);
    }
}

