/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.SonarPlatform;
import xyz.jonesdev.sonar.common.fallback.FallbackInboundHandler;
import xyz.jonesdev.sonar.common.util.FakeChannelUtil;
import xyz.jonesdev.sonar.common.util.exception.ReflectiveOperationException;

public final class FallbackInjectedChannelInitializer
extends ChannelInitializer<Channel> {
    private static final MethodHandle INIT_CHANNEL_METHOD;
    @NotNull
    private final ChannelInitializer<Channel> originalChannelInitializer;
    @NotNull
    private final Consumer<ChannelPipeline> sonarPipelineInjector;

    protected void initChannel(Channel channel) throws Exception {
        if (!channel.isActive()) {
            return;
        }
        try {
            INIT_CHANNEL_METHOD.invokeExact(this.originalChannelInitializer, channel);
        }
        catch (Throwable throwable) {
            throw new ReflectiveOperationException(throwable);
        }
        FallbackInjectedChannelInitializer.inject(channel, this.sonarPipelineInjector);
    }

    public static void inject(@NotNull Channel channel, Consumer<ChannelPipeline> sonarPipelineInjector) {
        if (channel.isActive() && !FakeChannelUtil.isFakeChannel(channel)) {
            FallbackInboundHandler inboundHandler = new FallbackInboundHandler(sonarPipelineInjector);
            if (Sonar.get0().getPlatform() == SonarPlatform.BUKKIT) {
                String encoder = Sonar.get0().getPlatform().getEncoder().apply(channel.pipeline());
                channel.pipeline().addBefore(encoder, "sonar-inbound-handler", (ChannelHandler)inboundHandler);
            } else {
                channel.pipeline().addFirst("sonar-inbound-handler", (ChannelHandler)inboundHandler);
            }
        }
    }

    public FallbackInjectedChannelInitializer(@NotNull ChannelInitializer<Channel> originalChannelInitializer, @NotNull Consumer<ChannelPipeline> sonarPipelineInjector) {
        if (originalChannelInitializer == null) {
            throw new NullPointerException("originalChannelInitializer is marked non-null but is null");
        }
        if (sonarPipelineInjector == null) {
            throw new NullPointerException("sonarPipelineInjector is marked non-null but is null");
        }
        this.originalChannelInitializer = originalChannelInitializer;
        this.sonarPipelineInjector = sonarPipelineInjector;
    }

    static {
        try {
            INIT_CHANNEL_METHOD = MethodHandles.privateLookupIn(ChannelInitializer.class, MethodHandles.lookup()).findVirtual(ChannelInitializer.class, "initChannel", MethodType.methodType(Void.TYPE, Channel.class));
        }
        catch (Throwable throwable) {
            throw new ReflectiveOperationException(throwable);
        }
    }
}

