/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.util.ByteProcessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public final class FallbackVarInt21FrameDecoder
extends ByteToMessageDecoder {
    protected void decode(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf byteBuf, @NotNull List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            byteBuf.clear();
            return;
        }
        int packetStart = byteBuf.forEachByte(ByteProcessor.FIND_NON_NUL);
        if (packetStart == -1) {
            byteBuf.clear();
            return;
        }
        byteBuf.readerIndex(packetStart);
        byteBuf.markReaderIndex();
        int preIndex = byteBuf.readerIndex();
        int length = FallbackVarInt21FrameDecoder.readRawVarInt21(byteBuf);
        if (preIndex == byteBuf.readerIndex()) {
            return;
        }
        if (length <= 0) {
            throw ProtocolUtil.DEBUG ? new DecoderException("Bad VarInt length: " + length) : QuietDecoderException.INSTANCE;
        }
        if (byteBuf.readableBytes() < length) {
            byteBuf.resetReaderIndex();
        } else {
            out.add(byteBuf.readRetainedSlice(length));
        }
    }

    private static int readRawVarInt21(@NotNull ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 4) {
            return FallbackVarInt21FrameDecoder.readRawVarIntSmallBuffer(byteBuf);
        }
        int wholeOrMore = byteBuf.getIntLE(byteBuf.readerIndex());
        int atStop = ~wholeOrMore & 0x808080;
        if (atStop == 0) {
            throw ProtocolUtil.DEBUG ? new DecoderException("VarInt too big") : QuietDecoderException.INSTANCE;
        }
        int bitsToKeep = Integer.numberOfTrailingZeros(atStop) + 1;
        byteBuf.skipBytes(bitsToKeep >> 3);
        int preservedBytes = wholeOrMore & (atStop ^ atStop - 1);
        preservedBytes = preservedBytes & 0x7F007F | (preservedBytes & 0x7F00) >> 1;
        preservedBytes = preservedBytes & 0x3FFF | (preservedBytes & 0x3FFF0000) >> 2;
        return preservedBytes;
    }

    private static int readRawVarIntSmallBuffer(@NotNull ByteBuf byteBuf) {
        if (!byteBuf.isReadable()) {
            return 0;
        }
        byteBuf.markReaderIndex();
        byte tmp = byteBuf.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (!byteBuf.isReadable()) {
            byteBuf.resetReaderIndex();
            return 0;
        }
        tmp = byteBuf.readByte();
        if (tmp >= 0) {
            return result | tmp << 7;
        }
        result |= (tmp & 0x7F) << 7;
        if (!byteBuf.isReadable()) {
            byteBuf.resetReaderIndex();
            return 0;
        }
        tmp = byteBuf.readByte();
        if (tmp >= 0) {
            return result | tmp << 14;
        }
        return result | (tmp & 0x7F) << 14;
    }
}

