/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;

public final class GameEventPacket
implements FallbackPacket {
    private int type;
    private float value;

    @Override
    public void encode(@NotNull ByteBuf byteBuf, ProtocolVersion protocolVersion) throws Exception {
        byteBuf.writeByte(this.type);
        byteBuf.writeFloat(this.value);
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public int getType() {
        return this.type;
    }

    public float getValue() {
        return this.value;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameEventPacket)) {
            return false;
        }
        GameEventPacket other = (GameEventPacket)o;
        if (this.getType() != other.getType()) {
            return false;
        }
        return Float.compare(this.getValue(), other.getValue()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        result = result * 59 + Float.floatToIntBits(this.getValue());
        return result;
    }

    public String toString() {
        return "GameEventPacket(type=" + this.getType() + ", value=" + this.getValue() + ")";
    }

    public GameEventPacket() {
    }

    public GameEventPacket(int type, float value) {
        this.type = type;
        this.value = value;
    }
}

