/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class MapDataPacket
implements FallbackPacket {
    private byte[] buffer;
    private int x;
    private int y;
    private int scaling;
    private boolean locked;

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) {
        ProtocolUtil.writeVarInt(byteBuf, 0);
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.writeShort(this.buffer.length + 3);
            byteBuf.writeByte(0);
            byteBuf.writeByte(this.x);
            byteBuf.writeByte(this.y);
            byteBuf.writeBytes(this.buffer);
            return;
        }
        byteBuf.writeByte(this.scaling);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_9) && protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_17)) {
            byteBuf.writeBoolean(false);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_14)) {
            byteBuf.writeBoolean(this.locked);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_17)) {
            byteBuf.writeBoolean(false);
        } else {
            ProtocolUtil.writeVarInt(byteBuf, 0);
        }
        byteBuf.writeByte(128);
        byteBuf.writeByte(128);
        byteBuf.writeByte(this.x);
        byteBuf.writeByte(this.y);
        ProtocolUtil.writeVarInt(byteBuf, this.buffer.length);
        byteBuf.writeBytes(this.buffer);
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getScaling() {
        return this.scaling;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public MapDataPacket() {
    }

    public MapDataPacket(byte[] buffer, int x, int y, int scaling, boolean locked) {
        this.buffer = buffer;
        this.x = x;
        this.y = y;
        this.scaling = scaling;
        this.locked = locked;
    }
}

