/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.item.ItemType;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class SetContainerSlotPacket
implements FallbackPacket {
    private int windowId;
    private int slot;
    private int count;
    private ItemType itemType;
    private CompoundBinaryTag compoundBinaryTag;

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2)) {
            ProtocolUtil.writeVarInt(byteBuf, this.windowId);
        } else {
            byteBuf.writeByte(this.windowId);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_17_1)) {
            ProtocolUtil.writeVarInt(byteBuf, 0);
        }
        byteBuf.writeShort(this.slot);
        if (protocolVersion.inBetween(ProtocolVersion.MINECRAFT_1_13_2, ProtocolVersion.MINECRAFT_1_20_3)) {
            byteBuf.writeBoolean(true);
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20_5)) {
            ProtocolUtil.writeVarInt(byteBuf, this.count);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_13_2)) {
            byteBuf.writeShort(this.itemType.getId().apply(protocolVersion).intValue());
        } else {
            ProtocolUtil.writeVarInt(byteBuf, this.itemType.getId().apply(protocolVersion));
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
            byteBuf.writeByte(this.count);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_13)) {
            byteBuf.writeShort(0);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_17)) {
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
                byteBuf.writeShort(-1);
            } else {
                byteBuf.writeByte(0);
            }
        } else if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
            ProtocolUtil.writeBinaryTag(byteBuf, protocolVersion, this.compoundBinaryTag);
        } else {
            ProtocolUtil.writeVarInt(byteBuf, 1);
            ProtocolUtil.writeVarInt(byteBuf, 0);
            ProtocolUtil.writeVarInt(byteBuf, this.itemType.getComponents().apply(protocolVersion));
            ProtocolUtil.writeVarInt(byteBuf, 0);
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getCount() {
        return this.count;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public CompoundBinaryTag getCompoundBinaryTag() {
        return this.compoundBinaryTag;
    }

    public String toString() {
        return "SetContainerSlotPacket(windowId=" + this.getWindowId() + ", slot=" + this.getSlot() + ", count=" + this.getCount() + ", itemType=" + String.valueOf((Object)this.getItemType()) + ", compoundBinaryTag=" + String.valueOf(this.getCompoundBinaryTag()) + ")";
    }

    public SetContainerSlotPacket() {
    }

    public SetContainerSlotPacket(int windowId, int slot, int count, ItemType itemType, CompoundBinaryTag compoundBinaryTag) {
        this.windowId = windowId;
        this.slot = slot;
        this.count = count;
        this.itemType = itemType;
        this.compoundBinaryTag = compoundBinaryTag;
    }
}

