/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.verification;

import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.fallback.FallbackUser;
import xyz.jonesdev.sonar.common.fallback.protocol.CaptchaPreparer;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.fallback.protocol.map.MapCaptchaInfo;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetPlayerPositionPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetPlayerPositionRotationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SystemChatPacket;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackVerificationHandler;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public final class FallbackCaptchaHandler
extends FallbackVerificationHandler {
    private final String answer;
    private int tries;
    private int lastCountdownIndex;
    private int keepAliveStreak;

    public FallbackCaptchaHandler(@NotNull FallbackUser user) {
        super(user);
        if (!CaptchaPreparer.isCaptchaAvailable()) {
            user.disconnect(Sonar.get0().getConfig().getVerification().getCurrentlyPreparing());
            throw QuietDecoderException.INSTANCE;
        }
        this.tries = Sonar.get0().getConfig().getVerification().getMap().getMaxTries();
        user.delayedWrite(FallbackPreparer.CAPTCHA_HELD_ITEM_SLOT);
        user.delayedWrite(FallbackPreparer.CAPTCHA_SET_CONTAINER_SLOT);
        MapCaptchaInfo captcha = CaptchaPreparer.getRandomCaptcha();
        this.answer = captcha.getAnswer().toLowerCase();
        captcha.delayedWrite(user);
        user.delayedWrite(FallbackPreparer.CAPTCHA_POSITION);
        user.delayedWrite(user.isGeyser() ? FallbackPreparer.NO_MOVE_ABILITIES_BEDROCK : FallbackPreparer.NO_MOVE_ABILITIES);
        user.delayedWrite(FallbackPreparer.enterCodeMessage);
        user.channel().flush();
    }

    @Override
    public void handle(@NotNull FallbackPacket packet) {
        int maxDuration = Sonar.get0().getConfig().getVerification().getMap().getMaxDuration();
        this.checkState(!this.user.getLoginTimer().elapsed(maxDuration), "took too long to enter CAPTCHA");
        if (packet instanceof SystemChatPacket) {
            SystemChatPacket chat = (SystemChatPacket)packet;
            if (chat.getMessage().toLowerCase().equals(this.answer)) {
                this.finishVerification();
                return;
            }
            this.checkState(this.tries-- > 0, "failed CAPTCHA too often");
            this.user.write(FallbackPreparer.incorrectCaptcha[this.tries]);
        } else if (packet instanceof SetPlayerPositionPacket || packet instanceof SetPlayerPositionRotationPacket) {
            if (Sonar.get0().getConfig().getVerification().getGamemode().isSurvivalOrAdventure()) {
                long difference = (long)maxDuration - this.user.getLoginTimer().delay();
                int index = (int)((double)difference / 1000.0);
                if (this.lastCountdownIndex != index && index >= 0 && FallbackPreparer.xpCountdown.length > index) {
                    this.user.write(FallbackPreparer.xpCountdown[index]);
                }
                this.lastCountdownIndex = index;
            }
            if (this.keepAliveStreak++ > 20) {
                this.keepAliveStreak = 0;
                this.user.write(FallbackPreparer.RANDOM_KEEP_ALIVE);
            }
        }
    }
}

