/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.verification;

import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.config.SonarConfiguration;
import xyz.jonesdev.sonar.api.fallback.FallbackUser;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketDecoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.ClientInformationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.ClientTickEndPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.ConfirmTeleportationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.PluginMessagePacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetPlayerPositionPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetPlayerPositionRotationPacket;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackPreJoinHandler;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackProtocolHandler;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackVerificationHandler;

public final class FallbackGravityHandler
extends FallbackVerificationHandler {
    private final FallbackPreJoinHandler preJoinHandler;
    private final boolean enableGravityCheck;
    private final boolean enableCollisionsCheck;
    private boolean teleported;
    private boolean canFall;
    private boolean checkMovement;
    private boolean expectClientTick;
    private boolean expectTeleportPosRot;
    private double y;
    private double deltaY;
    private double blockHeight;
    private int movementTick;
    private int tickWithoutMove;
    private int expectedTeleportId = FallbackPreparer.FIRST_TELEPORT_ID;
    private SetPlayerPositionRotationPacket lastPositionPacket;

    public FallbackGravityHandler(@NotNull FallbackUser user, @NotNull FallbackPreJoinHandler preJoinHandler) {
        super(user);
        this.preJoinHandler = preJoinHandler;
        this.canFall = user.isGeyser();
        this.enableGravityCheck = !user.isGeyser() && Sonar.get0().getConfig().getVerification().getGravity().isEnabled();
        this.enableCollisionsCheck = !user.isGeyser() && Sonar.get0().getConfig().getVerification().getGravity().isCheckCollisions();
        user.delayedWrite(FallbackPreparer.joinGame);
        if (Sonar.get0().getConfig().getVerification().getGamemode() == SonarConfiguration.Verification.Gamemode.CREATIVE) {
            user.delayedWrite(FallbackPreparer.DEFAULT_ABILITIES);
        }
        if (user.getProtocolVersion().greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19_3)) {
            user.delayedWrite(FallbackPreparer.defaultSpawnPosition);
        }
        if (user.getProtocolVersion().greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_8)) {
            user.delayedWrite(FallbackPreparer.spawnPosition);
            user.delayedWrite(FallbackPreparer.fallStartPosition);
        } else {
            user.delayedWrite(FallbackPreparer.fallStartPositionLegacy);
        }
        if (user.getProtocolVersion().greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_20_3)) {
            user.delayedWrite(FallbackPreparer.START_WRITING_CHUNKS);
            for (FallbackPacket section : FallbackPreparer.EMPTY_CHUNK_DATA) {
                user.delayedWrite(section);
            }
        } else {
            user.delayedWrite(FallbackPreparer.EMPTY_CHUNK_DATA[0]);
        }
        if (this.enableCollisionsCheck) {
            int index = RANDOM.nextInt(FallbackPreparer.BLOCKS_PACKETS.length);
            this.blockHeight = FallbackPreparer.POSSIBLE_BLOCK_TYPES[index].getBlockHeight().apply(user.getProtocolVersion());
            user.delayedWrite(FallbackPreparer.BLOCKS_PACKETS[index]);
        }
        if (FallbackPreparer.updateTime != null) {
            user.delayedWrite(FallbackPreparer.updateTime);
        }
        user.channel().flush();
        if (user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_9)) {
            this.teleported = true;
        }
    }

    @Override
    public void handle(@NotNull FallbackPacket packet) {
        if (packet instanceof SetPlayerPositionRotationPacket) {
            SetPlayerPositionRotationPacket position = (SetPlayerPositionRotationPacket)packet;
            if (this.teleported) {
                this.handleMovement(position.getX(), position.getY(), position.getZ(), position.isOnGround(), true);
            } else if (this.user.getProtocolVersion().equals((Object)ProtocolVersion.MINECRAFT_1_21_2)) {
                this.lastPositionPacket = position;
                return;
            }
            if (this.expectTeleportPosRot) {
                this.expectTeleportPosRot = false;
            } else {
                this.checkClientTick();
            }
        } else if (packet instanceof SetPlayerPositionPacket) {
            if (this.teleported) {
                SetPlayerPositionPacket position = (SetPlayerPositionPacket)packet;
                this.handleMovement(position.getX(), position.getY(), position.getZ(), position.isOnGround(), false);
            }
            this.checkClientTick();
        } else if (packet instanceof ConfirmTeleportationPacket) {
            ConfirmTeleportationPacket confirmTeleport = (ConfirmTeleportationPacket)packet;
            this.checkState(!this.teleported, "duplicate teleport confirm");
            this.checkState(confirmTeleport.getTeleportId() == this.expectedTeleportId, "expected TP ID " + this.expectedTeleportId + ", but got " + confirmTeleport.getTeleportId());
            boolean sendPosRotBefore = this.user.getProtocolVersion().equals((Object)ProtocolVersion.MINECRAFT_1_21_2);
            this.checkState(sendPosRotBefore ? this.lastPositionPacket != null : !this.expectTeleportPosRot, "expected position rotation but got teleport confirm.");
            if (!sendPosRotBefore) {
                this.expectTeleportPosRot = true;
            }
            if (this.expectedTeleportId == FallbackPreparer.FIRST_TELEPORT_ID) {
                this.expectedTeleportId = FallbackPreparer.SECOND_TELEPORT_ID;
            } else {
                this.teleported = true;
                if (sendPosRotBefore) {
                    this.handleMovement(this.lastPositionPacket.getX(), this.lastPositionPacket.getY(), this.lastPositionPacket.getZ(), this.lastPositionPacket.isOnGround(), true);
                }
            }
            this.lastPositionPacket = null;
        } else if (packet instanceof ClientInformationPacket || packet instanceof PluginMessagePacket) {
            this.preJoinHandler.handle(packet);
        } else if (packet instanceof ClientTickEndPacket) {
            this.lastPositionPacket = null;
            if (!this.expectClientTick) {
                if (++this.tickWithoutMove >= 20) {
                    // empty if block
                }
            } else {
                this.tickWithoutMove = 0;
                this.expectClientTick = false;
            }
        }
    }

    private void checkClientTick() {
        if (this.user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_21_2)) {
            return;
        }
        if (this.expectClientTick) {
            this.failOrShowCaptcha("expected client tick end but got position.");
        } else {
            this.expectClientTick = true;
        }
        this.tickWithoutMove = 0;
    }

    private void markSuccess() {
        this.teleported = false;
        if (!this.user.isGeyser() && this.user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            this.preJoinHandler.validateClientInformation();
        }
        ((FallbackPacketDecoder)this.user.channel().pipeline().get(FallbackPacketDecoder.class)).setListener(new FallbackProtocolHandler(this.user));
    }

    private void handleMovement(double x, double y, double z, boolean onGround, boolean rotated) {
        if (!this.checkMovement) {
            if (!this.enableGravityCheck && !this.enableCollisionsCheck) {
                this.markSuccess();
                return;
            }
            this.checkState(rotated, "illegal movement packet order");
            this.checkState(!onGround, "illegal ground state on teleport");
            this.checkState(x == 8.0, "invalid x: " + x);
            this.checkState(z == 8.0, "invalid z: " + z);
            this.y = FallbackPreparer.dynamicSpawnYPosition;
            this.checkMovement = true;
            if (FallbackPreparer.welcomeMessage != null) {
                this.user.write(FallbackPreparer.welcomeMessage);
            }
            return;
        }
        double lastDeltaY = this.deltaY;
        double lastY = this.y;
        this.deltaY = y - lastY;
        this.y = y;
        if (Sonar.get0().getConfig().getVerification().isDebugXYZPositions()) {
            Sonar.get0().getLogger().info("{}: {}/{}/{} ly={}, dy={}, h={}, g={}, r={}", this.user.getUsername(), x, y, z, lastY, this.deltaY, this.blockHeight, onGround, rotated);
        }
        if (y < (double)FallbackPreparer.PLATFORM_Y_POSITION) {
            this.failOrShowCaptcha("fell through blocks: " + y + "/" + this.deltaY + "/" + this.movementTick);
        }
        this.checkState(Math.abs(Math.abs(x) - 8.0) < 8.0, "illegal x offset: " + x);
        this.checkState(Math.abs(Math.abs(z) - 8.0) < 8.0, "illegal z offset: " + z);
        if (!onGround) {
            if (this.deltaY == 0.0) {
                this.checkState(rotated, "illegal movement packet order: " + this.deltaY);
                this.checkState(this.movementTick == 0, "illegal y motion: " + this.movementTick);
                if (this.user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_8)) {
                    ++this.movementTick;
                }
                this.canFall = true;
                return;
            }
            this.checkState(this.canFall, "unexpected y motion: " + this.deltaY);
            ++this.movementTick;
            if (this.enableGravityCheck) {
                double predicted = (lastDeltaY - 0.08) * (double)0.98f;
                double difference = Math.abs(this.deltaY - predicted);
                if (difference > 1.0E-7) {
                    this.failOrShowCaptcha("incorrect gravity: " + predicted + "/ " + this.deltaY + "/" + y);
                }
                if (!this.enableCollisionsCheck && this.movementTick == FallbackPreparer.maxMovementTick) {
                    this.markSuccess();
                }
            }
        } else if (this.enableCollisionsCheck) {
            double collisionOffsetY;
            if (this.enableGravityCheck && ++this.movementTick < FallbackPreparer.maxMovementTick) {
                this.failOrShowCaptcha("illegal collision tick: " + this.movementTick + "/" + this.blockHeight);
            }
            if ((collisionOffsetY = (double)FallbackPreparer.PLATFORM_Y_POSITION + this.blockHeight - y) != 0.0) {
                this.failOrShowCaptcha("illegal collision: " + collisionOffsetY + "/" + y + "/" + this.blockHeight);
            }
            this.markSuccess();
        }
    }

    private void failOrShowCaptcha(String debug) {
        if (Sonar.get0().getConfig().getVerification().getGravity().isCaptchaOnFail()) {
            this.user.setForceCaptcha(true);
            this.markSuccess();
            return;
        }
        this.fail(debug);
    }
}

