/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.verification;

import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.fallback.FallbackUser;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketDecoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.KeepAlivePacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.PaddleBoatPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.PlayerInputPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetPlayerPositionPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetPlayerPositionRotationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.SetPlayerRotationPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.packets.play.VehicleMovePacket;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackCaptchaHandler;
import xyz.jonesdev.sonar.common.fallback.verification.FallbackVerificationHandler;

public final class FallbackVehicleHandler
extends FallbackVerificationHandler {
    private boolean waitingForStateChange;
    private State state = State.WAITING;
    private State nextState;
    private int expectedKeepAliveId;
    private int rotations;
    private int inputs;
    private int paddles;
    private int vehicleMoves;
    private double boatMotion;
    private double boatY = FallbackPreparer.IN_AIR_Y_POSITION;

    public FallbackVehicleHandler(@NotNull FallbackUser user) {
        super(user);
        this.spawnVehicle(State.IN_BOAT);
    }

    @Override
    public void handle(@NotNull FallbackPacket packet) {
        if (packet instanceof KeepAlivePacket) {
            KeepAlivePacket keepAlivePacket = (KeepAlivePacket)packet;
            this.checkState(this.nextState != null, "invalid packet timing");
            this.checkState(keepAlivePacket.getId() == (long)this.expectedKeepAliveId, "expected K ID " + this.expectedKeepAliveId + ", but got " + keepAlivePacket.getId());
            this.state = this.nextState;
            this.nextState = null;
            this.waitingForStateChange = false;
        } else if (!this.waitingForStateChange) {
            if (packet instanceof PaddleBoatPacket) {
                if (this.state == State.IN_BOAT) {
                    ++this.paddles;
                }
            } else if (packet instanceof VehicleMovePacket) {
                if (this.state == State.IN_BOAT) {
                    VehicleMovePacket vehicleMove = (VehicleMovePacket)packet;
                    this.checkState(vehicleMove.getY() <= (double)FallbackPreparer.IN_AIR_Y_POSITION, "bad vehicle y: " + vehicleMove.getY());
                    double lastBoatMotion = this.boatMotion;
                    double lastBoatY = this.boatY;
                    this.boatY = vehicleMove.getY();
                    this.boatMotion = this.boatY - lastBoatY;
                    double predicted = lastBoatMotion - (double)0.04f;
                    double difference = Math.abs(this.boatMotion - predicted);
                    this.checkState(difference < 1.0E-7, "bad vehicle gravity: " + predicted + "/" + this.boatMotion);
                    ++this.vehicleMoves;
                }
            } else if (packet instanceof SetPlayerRotationPacket) {
                if (this.state.inVehicle) {
                    ++this.rotations;
                    if (this.user.getProtocolVersion().greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2)) {
                        this.handlePlayerInput();
                    }
                }
            } else if (packet instanceof PlayerInputPacket) {
                if (this.state.inVehicle && this.user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_21_2)) {
                    PlayerInputPacket playerInput = (PlayerInputPacket)packet;
                    float forward = Math.abs(playerInput.getForward());
                    float sideways = Math.abs(playerInput.getSideways());
                    float maxVehicleSpeed = 0.98f;
                    this.checkState(forward <= 0.98f, "illegal speed (f): " + forward);
                    this.checkState(sideways <= 0.98f, "illegal speed (s): " + sideways);
                    this.handlePlayerInput();
                }
            } else if (packet instanceof SetPlayerPositionRotationPacket) {
                SetPlayerPositionRotationPacket posRot = (SetPlayerPositionRotationPacket)packet;
                this.handleMovement(posRot.getY(), posRot.isOnGround());
            } else if (packet instanceof SetPlayerPositionPacket) {
                SetPlayerPositionPacket position = (SetPlayerPositionPacket)packet;
                this.handleMovement(position.getY(), position.isOnGround());
            }
        }
    }

    private void spawnVehicle(@NotNull State nextState) {
        this.user.delayedWrite(nextState == State.IN_BOAT ? FallbackPreparer.SPAWN_BOAT_ENTITY : FallbackPreparer.SPAWN_MINECART_ENTITY);
        this.user.delayedWrite(FallbackPreparer.SET_VEHICLE_PASSENGERS);
        this.prepareForNextState(nextState);
    }

    private void prepareForNextState(@NotNull State nextState) {
        this.nextState = nextState;
        this.waitingForStateChange = true;
        this.expectedKeepAliveId = RANDOM.nextInt();
        this.vehicleMoves = 0;
        this.paddles = 0;
        this.inputs = 0;
        this.rotations = 0;
        this.user.delayedWrite(new KeepAlivePacket(this.expectedKeepAliveId));
        this.user.channel().flush();
    }

    private void markSuccess() {
        if (this.user.isForceCaptcha() || Sonar.get0().getFallback().shouldPerformCaptcha()) {
            ((FallbackPacketDecoder)this.user.channel().pipeline().get(FallbackPacketDecoder.class)).setListener(new FallbackCaptchaHandler(this.user));
        } else {
            this.finishVerification();
        }
    }

    private void handleMovement(double y, boolean isOnGround) {
        if (this.state.inVehicle || this.state == State.WAITING) {
            return;
        }
        this.checkState(y <= this.boatY, "invalid y: " + y);
        this.checkState(!isOnGround, "invalid ground state: " + y);
        if (this.state == State.IN_AIR_AFTER_BOAT) {
            this.spawnVehicle(State.IN_MINECART);
        } else {
            this.markSuccess();
        }
    }

    private void handlePlayerInput() {
        if (this.user.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_9) || this.state == State.IN_MINECART) {
            ++this.paddles;
            ++this.vehicleMoves;
        }
        this.checkState(this.rotations >= this.inputs, "illegal packet order; i/r " + this.inputs + "/" + this.rotations);
        this.checkState(this.paddles >= this.inputs, "illegal packet order; i/p " + this.inputs + "/" + this.paddles);
        this.checkState(this.vehicleMoves >= this.inputs, "illegal packet order; i/v " + this.inputs + "/" + this.vehicleMoves);
        ++this.inputs;
        int minimumPackets = Sonar.get0().getConfig().getVerification().getVehicle().getMinimumPackets();
        if (this.inputs > minimumPackets && this.rotations > minimumPackets && this.paddles > minimumPackets && this.vehicleMoves > minimumPackets) {
            this.user.delayedWrite(FallbackPreparer.REMOVE_VEHICLE);
            this.prepareForNextState(this.state == State.IN_BOAT ? State.IN_AIR_AFTER_BOAT : State.IN_AIR_AFTER_MINECART);
        }
    }

    private static enum State {
        WAITING(false),
        IN_BOAT(true),
        IN_AIR_AFTER_BOAT(false),
        IN_MINECART(true),
        IN_AIR_AFTER_MINECART(false);

        private final boolean inVehicle;

        private State(boolean inVehicle) {
            this.inVehicle = inVehicle;
        }
    }
}

