/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.velocity;

import com.velocitypowered.api.command.Command;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.SonarPlatform;
import xyz.jonesdev.sonar.api.logger.LoggerWrapper;
import xyz.jonesdev.sonar.common.boot.SonarBootstrap;
import xyz.jonesdev.sonar.libs.bstats.charts.SimplePie;
import xyz.jonesdev.sonar.libs.bstats.velocity.Metrics;
import xyz.jonesdev.sonar.libs.libby.VelocityLibraryManager;
import xyz.jonesdev.sonar.velocity.SonarVelocityPlugin;
import xyz.jonesdev.sonar.velocity.command.VelocitySonarCommand;
import xyz.jonesdev.sonar.velocity.fallback.FallbackVelocityInjector;

public final class SonarVelocity
extends SonarBootstrap<SonarVelocityPlugin> {
    private final LoggerWrapper logger = new LoggerWrapper(){

        @Override
        public void info(String message, Object ... args) {
            ((SonarVelocityPlugin)SonarVelocity.this.getPlugin()).getLogger().info(message, args);
        }

        @Override
        public void warn(String message, Object ... args) {
            ((SonarVelocityPlugin)SonarVelocity.this.getPlugin()).getLogger().warn(message, args);
        }

        @Override
        public void error(String message, Object ... args) {
            ((SonarVelocityPlugin)SonarVelocity.this.getPlugin()).getLogger().error(message, args);
        }
    };
    private Metrics metrics;

    public SonarVelocity(@NotNull SonarVelocityPlugin plugin) {
        super(plugin, SonarPlatform.VELOCITY, plugin.getDataDirectory().toFile(), new VelocityLibraryManager<SonarVelocityPlugin>(plugin, plugin.getLogger(), plugin.getDataDirectory(), plugin.getServer().getPluginManager()));
    }

    @Override
    @Nullable
    public Audience audience(@Nullable UUID uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        return ((SonarVelocityPlugin)this.getPlugin()).getServer().getPlayer(uniqueId).orElse(null);
    }

    @Override
    @Deprecated
    @NotNull
    public Audience sender(@NotNull Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void enable() {
        this.metrics = ((SonarVelocityPlugin)this.getPlugin()).getMetricsFactory().make(this.getPlugin(), this.getPlatform().getMetricsId());
        this.metrics.addCustomChart(new SimplePie("verification", () -> this.getConfig().getVerification().getTiming().getDisplayName()));
        this.metrics.addCustomChart(new SimplePie("captcha", () -> this.getConfig().getVerification().getMap().getTiming().getDisplayName()));
        this.metrics.addCustomChart(new SimplePie("language", () -> this.getConfig().getLanguage().getName()));
        this.metrics.addCustomChart(new SimplePie("database_type", () -> this.getConfig().getDatabase().getType().getDisplayName()));
        ((SonarVelocityPlugin)this.getPlugin()).getServer().getCommandManager().register(((SonarVelocityPlugin)this.getPlugin()).getServer().getCommandManager().metaBuilder("sonar").plugin(this.getPlugin()).build(), (Command)new VelocitySonarCommand());
        FallbackVelocityInjector.inject(((SonarVelocityPlugin)this.getPlugin()).getServer());
    }

    @Override
    public void disable() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    @Override
    public LoggerWrapper getLogger() {
        return this.logger;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

