/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import org.slf4j.Logger;
import xyz.jonesdev.sonar.libs.bstats.velocity.Metrics;
import xyz.jonesdev.sonar.velocity.SonarVelocity;

public final class SonarVelocityPlugin {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private final Metrics.Factory metricsFactory;
    private SonarVelocity bootstrap;

    @Inject
    public SonarVelocityPlugin(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void handle(ProxyInitializeEvent event) {
        this.bootstrap = new SonarVelocity(this);
        this.bootstrap.initialize();
    }

    @Subscribe
    public void handle(ProxyShutdownEvent event) {
        this.bootstrap.shutdown();
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    public SonarVelocity getBootstrap() {
        return this.bootstrap;
    }
}

