/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.velocity.fallback;

import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.network.ConnectionManager;
import com.velocitypowered.proxy.network.ServerChannelInitializerHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Field;
import xyz.jonesdev.sonar.common.fallback.netty.FallbackInjectedChannelInitializer;
import xyz.jonesdev.sonar.common.util.exception.ReflectiveOperationException;
import xyz.jonesdev.sonar.velocity.fallback.FallbackVelocityInboundHandler;

public final class FallbackVelocityInjector {
    private static final Field CONNECTION_MANAGER_FIELD;
    private static final Field SERVER_CHANNEL_INITIALIZER_FIELD;

    public static void inject(Object proxyServer) {
        try {
            ConnectionManager connectionManager = (ConnectionManager)CONNECTION_MANAGER_FIELD.get(proxyServer);
            ChannelInitializer originalInitializer = connectionManager.serverChannelInitializer.get();
            FallbackInjectedChannelInitializer injectedInitializer = new FallbackInjectedChannelInitializer((ChannelInitializer<Channel>)originalInitializer, pipeline -> pipeline.addAfter("minecraft-decoder", "sonar-packet-handler", (ChannelHandler)new FallbackVelocityInboundHandler()));
            SERVER_CHANNEL_INITIALIZER_FIELD.set(connectionManager.getServerChannelInitializer(), (Object)injectedInitializer);
        }
        catch (Throwable throwable) {
            throw new ReflectiveOperationException(throwable);
        }
    }

    private FallbackVelocityInjector() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try {
            CONNECTION_MANAGER_FIELD = VelocityServer.class.getDeclaredField("cm");
            CONNECTION_MANAGER_FIELD.setAccessible(true);
            SERVER_CHANNEL_INITIALIZER_FIELD = ServerChannelInitializerHolder.class.getDeclaredField("initializer");
            SERVER_CHANNEL_INITIALIZER_FIELD.setAccessible(true);
        }
        catch (Throwable throwable) {
            throw new ReflectiveOperationException(throwable);
        }
    }
}

