/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.time.formatter;

import com.sakuraryoko.corelib.api.time.TimeFormat;
import com.sakuraryoko.corelib.impl.CoreLib;
import com.sakuraryoko.corelib.impl.time.formatter.TimeFmt;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TimeFmtDateOnly
extends TimeFmt {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ROOT);

    public TimeFmtDateOnly(TimeFormat fmt) {
        super(fmt);
        this.formatString = "yyyy-MM-dd";
    }

    @Override
    public String formatTo(long time, @Nullable String fmt) {
        return this.formatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
    }

    @Override
    public long formatFrom(@Nonnull String formatted, @Nullable String fmt) {
        LocalDateTime dateTime;
        try {
            dateTime = LocalDateTime.parse(formatted, this.formatter);
        }
        catch (Exception err) {
            CoreLib.LOGGER.error("fromFormat(): Invalid Date/Time format // {}", (Object)err.getMessage());
            return 0L;
        }
        return dateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    @Override
    public String formatNow(@Nullable String fmt) {
        return this.formatter.format(ZonedDateTime.now());
    }
}

