/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.morecolors.impl.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sakuraryoko.corelib.api.commands.IServerCommand;
import com.sakuraryoko.corelib.api.config.IConfigDispatch;
import com.sakuraryoko.corelib.api.modinit.ModInitData;
import com.sakuraryoko.corelib.impl.config.ConfigManager;
import com.sakuraryoko.morecolors.impl.MoreColor;
import com.sakuraryoko.morecolors.impl.config.ConfigWrap;
import com.sakuraryoko.morecolors.impl.config.MoreColorConfigHandler;
import com.sakuraryoko.morecolors.impl.modinit.MoreColorInit;
import com.sakuraryoko.morecolors.impl.nodes.MoreColorNode;
import com.sakuraryoko.morecolors.impl.nodes.NodeManager;
import com.sakuraryoko.morecolors.impl.text.FormattingExample;
import com.sakuraryoko.morecolors.impl.text.TextUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MoreColorsCommand
implements IServerCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)this.getName()).requires(Permissions.require((String)this.getNode(), (int)ConfigWrap.opt().moreColorsCommandPermissions))).executes(ctx -> this.about((class_2168)ctx.getSource(), (CommandContext<class_2168>)ctx))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"test").requires(Permissions.require((String)(this.getNode() + ".test"), (int)ConfigWrap.opt().moreColorsTestCommandPermissions))).executes(ctx -> this.test((class_2168)ctx.getSource(), "all", (CommandContext<class_2168>)ctx))).then(class_2170.method_9247((String)"all").executes(ctx -> this.test((class_2168)ctx.getSource(), "all", (CommandContext<class_2168>)ctx)))).then(class_2170.method_9247((String)"vanilla").executes(ctx -> this.test((class_2168)ctx.getSource(), "vanilla", (CommandContext<class_2168>)ctx)))).then(class_2170.method_9247((String)"placeholder").executes(ctx -> this.test((class_2168)ctx.getSource(), "placeholder", (CommandContext<class_2168>)ctx)))).then(class_2170.method_9247((String)"morecolors").executes(ctx -> this.test((class_2168)ctx.getSource(), "morecolors", (CommandContext<class_2168>)ctx))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(Permissions.require((String)(this.getNode() + ".add"), (int)ConfigWrap.opt().moreColorsAddCommandPermissions))).then(class_2170.method_9244((String)"node", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"hexCode", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.add((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"node"), StringArgumentType.getString((CommandContext)ctx, (String)"hexCode"), null, (CommandContext<class_2168>)ctx))).then(class_2170.method_9244((String)"alias_list", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.add((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"node"), StringArgumentType.getString((CommandContext)ctx, (String)"hexCode"), StringArgumentType.getString((CommandContext)ctx, (String)"alias_list"), (CommandContext<class_2168>)ctx))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)(this.getNode() + ".reload"), (int)ConfigWrap.opt().moreColorsReloadCommandPermissions))).executes(ctx -> this.reload((class_2168)ctx.getSource(), (CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save").requires(Permissions.require((String)(this.getNode() + ".save"), (int)ConfigWrap.opt().moreColorsSaveCommandPermissions))).executes(ctx -> this.save((class_2168)ctx.getSource(), (CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"defaults").requires(Permissions.require((String)(this.getNode() + ".defaults"), (int)ConfigWrap.opt().moreColorsDefaultsCommandPermissions))).executes(ctx -> this.defaults((class_2168)ctx.getSource(), (CommandContext<class_2168>)ctx))));
    }

    public String getName() {
        return "morecolors";
    }

    public String getModId() {
        return "more-color-api";
    }

    private int about(class_2168 src, CommandContext<class_2168> context) {
        List info = MoreColorInit.getInstance().getPlaceholderFormatted(ModInitData.ALL_INFO);
        String user = src.method_9214();
        for (class_2561 entry : info) {
            ((class_2168)context.getSource()).method_9226(entry, false);
        }
        MoreColor.debugLog("{} has executed /morecolors .", user);
        return 1;
    }

    private int test(class_2168 src, String type, CommandContext<class_2168> context) {
        String user = src.method_9214();
        switch (type) {
            case "vanilla": {
                ((class_2168)context.getSource()).method_9226(FormattingExample.runBuiltInTest(), false);
                break;
            }
            case "placeholder": {
                ((class_2168)context.getSource()).method_9226(FormattingExample.runPlaceholderAPITest(), false);
                break;
            }
            case "morecolors": {
                ((class_2168)context.getSource()).method_9226(FormattingExample.runMoreColorsTest(), false);
                break;
            }
            default: {
                ((class_2168)context.getSource()).method_9226(FormattingExample.runBuiltInTest(), false);
                ((class_2168)context.getSource()).method_9226(FormattingExample.runPlaceholderAPITest(), false);
                ((class_2168)context.getSource()).method_9226(FormattingExample.runMoreColorsTest(), false);
            }
        }
        ((class_2168)context.getSource()).method_9226(FormattingExample.getClipboardMessage(), false);
        MoreColor.debugLog("{} has executed /morecolors example .", user);
        return 1;
    }

    private int add(class_2168 src, String node, String hexCode, @Nullable String aliases, CommandContext<class_2168> context) {
        MoreColorNode newNode;
        String user = src.method_9214();
        if (node == null || node.isEmpty()) {
            return 0;
        }
        if (hexCode == null || hexCode.isEmpty()) {
            return 0;
        }
        if (aliases == null || aliases.isEmpty()) {
            newNode = new MoreColorNode(node, "#" + hexCode.toUpperCase(Locale.ROOT));
        } else {
            String[] arrString = aliases.split("\\W+");
            newNode = new MoreColorNode(node, "#" + hexCode.toUpperCase(Locale.ROOT), Arrays.stream(arrString).toList());
        }
        if (newNode.getColor() != null && !NodeManager.checkIfRegistered(newNode)) {
            MoreColor.debugLog("New Node Debug: [{}]", newNode.toString());
            ConfigWrap.colors().add(newNode);
            NodeManager.registerColor(newNode);
            class_2561 result = TextUtils.getInstance().formatText("More Color Node added successfully\nTest (Click to copy): <r><copy:'<" + newNode.getName() + ">'><" + newNode.getName() + ">" + newNode.getName() + "<r>");
            ((class_2168)context.getSource()).method_9226(result, false);
            MoreColor.LOGGER.info("{} has added a new color node [{}] to the configuration.", (Object)user, (Object)newNode.getName());
            return 1;
        }
        return 0;
    }

    private int reload(class_2168 src, CommandContext<class_2168> context) {
        String user = src.method_9214();
        ConfigManager.getInstance().reloadEach((IConfigDispatch)MoreColorConfigHandler.getInstance());
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Reloaded config!"), false);
        MoreColor.LOGGER.info("{} has reloaded the configuration.", (Object)user);
        return 1;
    }

    private int save(class_2168 src, CommandContext<class_2168> context) {
        String user = src.method_9214();
        ConfigManager.getInstance().saveEach((IConfigDispatch)MoreColorConfigHandler.getInstance());
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Saved config!"), false);
        MoreColor.LOGGER.info("{} has saved the configuration.", (Object)user);
        return 1;
    }

    private int defaults(class_2168 src, CommandContext<class_2168> context) {
        String user = src.method_9214();
        ConfigManager.getInstance().defaultEach((IConfigDispatch)MoreColorConfigHandler.getInstance());
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Loading Config Defaults!"), false);
        MoreColor.LOGGER.info("{} has loaded the default configuration.", (Object)user);
        return 1;
    }
}

