/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.api;

import com.sakuraryoko.corelib.api.commands.IServerCommand;
import com.sakuraryoko.corelib.api.config.IConfigDispatch;
import com.sakuraryoko.corelib.api.events.IClientEventsDispatch;
import com.sakuraryoko.corelib.api.events.IPlayerEventsDispatch;
import com.sakuraryoko.corelib.api.events.IServerEventsDispatch;
import com.sakuraryoko.corelib.api.modinit.IModInitDispatcher;
import com.sakuraryoko.corelib.impl.CoreLib;
import com.sakuraryoko.corelib.impl.commands.CommandManager;
import com.sakuraryoko.corelib.impl.config.ConfigManager;
import com.sakuraryoko.corelib.impl.events.client.ClientEventsManager;
import com.sakuraryoko.corelib.impl.events.players.PlayerEventsManager;
import com.sakuraryoko.corelib.impl.events.server.ServerEventsManager;
import com.sakuraryoko.corelib.impl.modinit.ModInitManager;
import com.sakuraryoko.corelib.impl.time.TimeTestExample;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;

public interface CoreLibAPI {
    public static boolean registerModInitHandler(@Nonnull IModInitDispatcher dispatch) {
        try {
            ModInitManager.getInstance().registerModInitHandler(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using registerModInitHandler() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static boolean registerConfigDispatch(@Nonnull IConfigDispatch dispatch) {
        try {
            ConfigManager.getInstance().registerConfigDispatcher(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using registerConfigDispatch() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static void initAllConfigs() {
        ConfigManager.getInstance().initAllConfigs();
    }

    public static void defaultAllConfigs() {
        ConfigManager.getInstance().defaultAllConfigs();
    }

    public static void loadAllConfigs() {
        ConfigManager.getInstance().loadAllConfigs();
    }

    public static void saveAllConfigs() {
        ConfigManager.getInstance().saveAllConfigs();
    }

    public static void reloadAllConfigs() {
        ConfigManager.getInstance().reloadAllConfigs();
    }

    public static boolean initEachConfig(@Nonnull IConfigDispatch dispatch) {
        try {
            ConfigManager.getInstance().initEach(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using initEachConfig() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static boolean defaultEachConfig(@Nonnull IConfigDispatch dispatch) {
        try {
            ConfigManager.getInstance().defaultEach(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using defaultEachConfig() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static boolean loadEachConfig(@Nonnull IConfigDispatch dispatch) {
        try {
            ConfigManager.getInstance().loadEach(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using loadEachConfig() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static boolean saveEachConfig(@Nonnull IConfigDispatch dispatch) {
        try {
            ConfigManager.getInstance().saveEach(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using saveEachConfig() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static boolean reloadEachConfig(@Nonnull IConfigDispatch dispatch) {
        try {
            ConfigManager.getInstance().reloadEach(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using reloadEachConfig() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static boolean registerServerCommand(@Nonnull IServerCommand command) {
        try {
            CommandManager.getInstance().registerCommandHandler(command);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using registerServerCommand() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static boolean registerClientEventsDispatcher(IClientEventsDispatch dispatch) {
        try {
            ClientEventsManager.getInstance().registerClientEvents(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using registerClientEventsDispatcher() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static boolean registerServerEventsDispatcher(IServerEventsDispatch dispatch) {
        try {
            ServerEventsManager.getInstance().registerEventDispatcher(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using registerServerEventsDispatcher() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static boolean registerPlayerEventsDispatcher(IPlayerEventsDispatch dispatch) {
        try {
            PlayerEventsManager.getInstance().registerPlayerEvents(dispatch);
            return true;
        }
        catch (RuntimeException err) {
            CoreLib.LOGGER.error("RuntimeException using registerPlayerEventsDispatcher() --> {}", (Object)err.getMessage());
            return false;
        }
    }

    public static class_2561 getTimeDurationTest(boolean usePlaceholder) {
        return TimeTestExample.runDurationTest(usePlaceholder);
    }

    public static class_2561 getTimeDateTest(boolean usePlaceholder) {
        return TimeTestExample.runTimeDateTest(usePlaceholder);
    }
}

