/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.events.client;

import com.sakuraryoko.corelib.api.events.IClientEventsDispatch;
import com.sakuraryoko.corelib.impl.CoreLib;
import com.sakuraryoko.corelib.impl.events.client.IClientEventsManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public class ClientEventsManager
implements IClientEventsManager {
    private static final ClientEventsManager INSTANCE = new ClientEventsManager();
    private final List<IClientEventsDispatch> DISPATCH = new ArrayList<IClientEventsDispatch>();

    public static IClientEventsManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerClientEvents(IClientEventsDispatch handler) throws RuntimeException {
        if (this.DISPATCH.contains(handler)) {
            throw new RuntimeException("Client Events dispatcher has already been registered!");
        }
        this.DISPATCH.add(handler);
    }

    @ApiStatus.Internal
    public void worldChangePre(@Nullable class_638 world) {
        CoreLib.debugLog("worldChangePre()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.worldChangePre(world));
        }
    }

    @ApiStatus.Internal
    public void worldChangePost(@Nullable class_638 world) {
        CoreLib.debugLog("worldChangePost()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.worldChangePost(world));
        }
    }

    @ApiStatus.Internal
    public void onJoining(@Nullable class_638 world) {
        CoreLib.debugLog("onJoining()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onJoining(world));
        }
    }

    @ApiStatus.Internal
    public void onOpenConnection(@Nullable class_638 world) {
        CoreLib.debugLog("onOpenConnection()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onOpenConnection(world));
        }
    }

    @ApiStatus.Internal
    public void onJoined(@Nullable class_638 world) {
        CoreLib.debugLog("onJoined()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onJoined(world));
        }
    }

    @ApiStatus.Internal
    public void onGameJoinPre(@Nullable class_638 world) {
        CoreLib.debugLog("onGameJoinPre()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onGameJoinPre(world));
        }
    }

    @ApiStatus.Internal
    public void onGameJoinPost(@Nullable class_638 world) {
        CoreLib.debugLog("onGameJoinPost()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onGameJoinPost(world));
        }
    }

    @ApiStatus.Internal
    public void onDimensionChangePre(@Nullable class_638 world) {
        CoreLib.debugLog("onDimensionChangePre()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onDimensionChangePre(world));
        }
    }

    @ApiStatus.Internal
    public void onDimensionChangePost(@Nullable class_638 world) {
        CoreLib.debugLog("onDimensionChangePost()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onDimensionChangePost(world));
        }
    }

    @ApiStatus.Internal
    public void onDisconnecting(@Nullable class_638 world) {
        CoreLib.debugLog("onDisconnecting()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onDisconnecting(world));
        }
    }

    @ApiStatus.Internal
    public void onCloseConnection(@Nullable class_638 world) {
        CoreLib.debugLog("onCloseConnection()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onCloseConnection(world));
        }
    }

    @ApiStatus.Internal
    public void onDisconnected(@Nullable class_638 world) {
        CoreLib.debugLog("onDisconnected()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.onDisconnected(world));
        }
    }
}

