/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.sakuraryoko.corelib.api.config.IConfigData;
import com.sakuraryoko.corelib.api.config.IConfigDispatch;
import com.sakuraryoko.corelib.impl.CoreLib;
import com.sakuraryoko.corelib.impl.Reference;
import com.sakuraryoko.corelib.impl.config.IConfigManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public class ConfigManager
implements IConfigManager {
    private static final ConfigManager INSTANCE = new ConfigManager();
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final List<IConfigDispatch> DISPATCH = new ArrayList<IConfigDispatch>();

    public static IConfigManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerConfigDispatcher(IConfigDispatch dispatch) throws RuntimeException {
        if (this.DISPATCH.contains(dispatch)) {
            throw new RuntimeException("Config Dispatch has already been registered");
        }
        this.DISPATCH.add(dispatch);
        this.initEach(dispatch);
        dispatch.onPreLoadConfig();
        this.loadEachInternal(dispatch, true);
        dispatch.onPostLoadConfig();
    }

    @Override
    public void initAllConfigs() {
        for (IConfigDispatch dispatch : this.DISPATCH) {
            dispatch.initConfig();
        }
    }

    @Override
    public void loadAllConfigs() {
        for (IConfigDispatch dispatch : this.DISPATCH) {
            dispatch.onPreLoadConfig();
            this.loadEachInternal(dispatch, false);
            dispatch.onPostLoadConfig();
        }
    }

    @Override
    public void defaultAllConfigs() {
        for (IConfigDispatch dispatch : this.DISPATCH) {
            dispatch.onPreLoadConfig();
            dispatch.update(dispatch.defaults());
            dispatch.onPostLoadConfig();
            dispatch.execute(true);
        }
    }

    @Override
    public void saveAllConfigs() {
        for (IConfigDispatch dispatch : this.DISPATCH) {
            if (!dispatch.isLoaded()) continue;
            dispatch.onPreSaveConfig();
            this.saveEachInternal(dispatch);
            dispatch.onPostSaveConfig();
        }
    }

    @Override
    public void reloadAllConfigs() {
        for (IConfigDispatch dispatch : this.DISPATCH) {
            dispatch.onPreLoadConfig();
            this.loadEachInternal(dispatch, false);
            dispatch.onPostLoadConfig();
        }
    }

    @Override
    public void initEach(IConfigDispatch handler) throws RuntimeException {
        if (!this.DISPATCH.contains(handler)) {
            throw new RuntimeException("Config Dispatch has not been registered");
        }
        handler.initConfig();
    }

    @Override
    public void defaultEach(IConfigDispatch handler) throws RuntimeException {
        if (!this.DISPATCH.contains(handler)) {
            throw new RuntimeException("Config Dispatch has not been registered");
        }
        handler.onPreLoadConfig();
        handler.update(handler.defaults());
        handler.onPostLoadConfig();
        handler.execute(true);
    }

    @Override
    public void loadEach(IConfigDispatch handler) throws RuntimeException {
        if (!this.DISPATCH.contains(handler)) {
            throw new RuntimeException("Config Dispatch has not been registered");
        }
        handler.onPreLoadConfig();
        this.loadEachInternal(handler, false);
        handler.onPostLoadConfig();
    }

    @Override
    public void saveEach(IConfigDispatch handler) throws RuntimeException {
        if (this.DISPATCH.contains(handler)) {
            if (handler.isLoaded()) {
                handler.onPreSaveConfig();
                this.saveEachInternal(handler);
                handler.onPostSaveConfig();
            }
        } else {
            throw new RuntimeException("Config Dispatch has not been registered");
        }
    }

    @Override
    public void reloadEach(IConfigDispatch handler) throws RuntimeException {
        if (!this.DISPATCH.contains(handler)) {
            throw new RuntimeException("Config Dispatch has not been registered");
        }
        handler.onPreLoadConfig();
        this.loadEachInternal(handler, false);
        handler.onPostLoadConfig();
    }

    @ApiStatus.Internal
    private void loadEachInternal(IConfigDispatch config, boolean fromInit) {
        IConfigData conf = config.newConfig();
        CoreLib.debugLog("loadEach(): --> [{}/{}.json]", config.getConfigRoot(), config.getConfigName());
        try {
            Path file;
            Path dir = config.useRootDir() ? Reference.CONFIG_DIR : Reference.CONFIG_DIR.resolve(config.getConfigRoot());
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            if (Files.exists(file = dir.resolve(config.getConfigName() + ".json"), new LinkOption[0])) {
                JsonElement data = JsonParser.parseString((String)Files.readString(file));
                conf = (IConfigData)this.GSON.fromJson(data, conf.getClass());
                CoreLib.LOGGER.info("loadEach(): Read config for [{}/{}]", (Object)dir.getFileName().toString(), (Object)file.getFileName().toString());
            } else {
                conf = config.defaults();
                CoreLib.LOGGER.info("loadEach(): Config defaults for [{}/{}.json]", (Object)config.getConfigRoot(), (Object)config.getConfigName());
            }
            conf = config.update(conf);
            Files.writeString(file, (CharSequence)this.GSON.toJson((Object)conf), new OpenOption[0]);
            config.execute(false);
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("loadEach(): Error reading config [{}/{}.json] // {}", (Object)config.getConfigRoot(), (Object)config.getConfigName(), (Object)e.getMessage());
        }
    }

    @ApiStatus.Internal
    private void saveEachInternal(IConfigDispatch config) {
        CoreLib.debugLog("saveEach(): --> [{}/{}.json]", config.getConfigRoot(), config.getConfigName());
        try {
            IConfigData conf;
            Path file;
            Path dir = config.useRootDir() ? Reference.CONFIG_DIR : Reference.CONFIG_DIR.resolve(config.getConfigRoot());
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            if (Files.exists(file = dir.resolve(config.getConfigName() + ".json"), new LinkOption[0])) {
                CoreLib.LOGGER.info("saveEach(): Deleting existing config file: [{}/{}]", (Object)dir.getFileName().toString(), (Object)file.getFileName().toString());
                Files.delete(file);
            }
            if ((conf = config.getConfig()) != null) {
                Files.writeString(file, (CharSequence)this.GSON.toJson((Object)conf), new OpenOption[0]);
                CoreLib.LOGGER.info("saveEach(): Wrote config for [{}/{}.json]", (Object)config.getConfigRoot(), (Object)config.getConfigName());
            } else {
                CoreLib.LOGGER.error("saveEach(): Error saving config file [{}/{}.json] // config is empty!", (Object)config.getConfigRoot(), (Object)config.getConfigName());
            }
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("saveEach(): Error saving config file [{}/{}.json] // {}", (Object)config.getConfigRoot(), (Object)config.getConfigName(), (Object)e.getMessage());
        }
    }
}

