/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.time;

import com.sakuraryoko.corelib.api.time.DurationFormat;
import com.sakuraryoko.corelib.impl.time.formatter.DurationFmt;
import com.sakuraryoko.corelib.impl.time.formatter.DurationFmtFormatted;
import com.sakuraryoko.corelib.impl.time.formatter.DurationFmtISOExtended;
import com.sakuraryoko.corelib.impl.time.formatter.DurationFmtPretty;
import com.sakuraryoko.corelib.impl.time.formatter.DurationFmtRegular;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DurationFmtType<T extends DurationFmt> {
    public static final DurationFmtType<DurationFmtRegular> REGULAR = DurationFmtType.create(DurationFmtRegular::new, DurationFormat.REGULAR);
    public static final DurationFmtType<DurationFmtPretty> PRETTY = DurationFmtType.create(DurationFmtPretty::new, DurationFormat.PRETTY);
    public static final DurationFmtType<DurationFmtISOExtended> ISO_EXTENDED = DurationFmtType.create(DurationFmtISOExtended::new, DurationFormat.ISO_EXTENDED);
    public static final DurationFmtType<DurationFmtFormatted> FORMATTED = DurationFmtType.create(DurationFmtFormatted::new, DurationFormat.FORMATTED);
    private final DurationFactory<? extends T> factory;
    private final DurationFormat durationFmt;

    private static <T extends DurationFmt> DurationFmtType<T> create(DurationFactory<? extends T> factory, DurationFormat durationFmt) {
        return new DurationFmtType<T>(factory, durationFmt);
    }

    private DurationFmtType(DurationFactory<? extends T> factory, DurationFormat durationFmt) {
        this.durationFmt = durationFmt;
        this.factory = factory;
    }

    @Nullable
    public T init(DurationFormat fmt) {
        return this.factory.create(fmt);
    }

    public DurationFormat getFmt() {
        return this.durationFmt;
    }

    @FunctionalInterface
    static interface DurationFactory<T extends DurationFmt> {
        public T create(DurationFormat var1);
    }
}

