/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.time.formatter;

import com.sakuraryoko.corelib.api.time.TimeFormat;
import com.sakuraryoko.corelib.impl.CoreLib;
import com.sakuraryoko.corelib.impl.time.formatter.TimeFmt;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TimeFmtRFC1123
extends TimeFmt {
    private final DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME;

    public TimeFmtRFC1123(TimeFormat fmt) {
        super(fmt);
        this.formatString = "EEE, dd MMM yyyy HH:mm:ss +HHMM";
    }

    @Override
    public String formatTo(long time, @Nullable String fmt) {
        return this.formatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
    }

    @Override
    public long formatFrom(@Nonnull String formatted, @Nullable String fmt) {
        LocalDateTime dateTime;
        try {
            dateTime = LocalDateTime.parse(formatted, this.formatter);
        }
        catch (Exception err) {
            CoreLib.LOGGER.error("fromFormat(): Invalid Date/Time format // {}", (Object)err.getMessage());
            return 0L;
        }
        return dateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    @Override
    public String formatNow(@Nullable String fmt) {
        return this.formatter.format(ZonedDateTime.now());
    }
}

