/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.time.formatter;

import com.sakuraryoko.corelib.api.time.DurationFormat;
import com.sakuraryoko.corelib.impl.CoreLib;
import com.sakuraryoko.corelib.impl.time.formatter.DurationFmt;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DurationFmtFormatted
extends DurationFmt {
    private final String defaultFormat;

    public DurationFmtFormatted(DurationFormat fmt) {
        super(fmt);
        this.formatString = this.defaultFormat = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'";
    }

    @Override
    public String format(long duration, @Nullable String fmt) {
        if (fmt != null && !fmt.isEmpty()) {
            try {
                return DurationFormatUtils.formatDuration((long)duration, (String)fmt, (boolean)true);
            }
            catch (Exception err) {
                CoreLib.LOGGER.error("format(): Invalid Duration format // {}", (Object)err.getMessage());
            }
        }
        return DurationFormatUtils.formatDuration((long)duration, (String)this.defaultFormat, (boolean)true);
    }
}

