/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.events.players;

import com.mojang.authlib.GameProfile;
import com.sakuraryoko.corelib.api.events.IPlayerEventsDispatch;
import com.sakuraryoko.corelib.impl.CoreLib;
import com.sakuraryoko.corelib.impl.events.players.IPlayerEventsManager;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

public class PlayerEventsManager
implements IPlayerEventsManager {
    private static final PlayerEventsManager INSTANCE = new PlayerEventsManager();
    private final List<IPlayerEventsDispatch> DISPATCH = new ArrayList<IPlayerEventsDispatch>();
    private GameProfile lastProfile = null;

    public static IPlayerEventsManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerPlayerEvents(IPlayerEventsDispatch dispatch) throws RuntimeException {
        if (this.DISPATCH.contains(dispatch)) {
            throw new RuntimeException("Player Events Dispatch is already registered!");
        }
        this.DISPATCH.add(dispatch);
    }

    @ApiStatus.Internal
    public void onConnection(SocketAddress addr, GameProfile profile, @Nullable class_2561 result) {
        if (result == null) {
            CoreLib.debugLog("onConnection: connection from {} // {}", addr.toString(), profile.getId().toString());
        } else {
            CoreLib.debugLog("onConnection: connection from {} // {} --> result: {}", addr.toString(), profile.getId().toString(), result.getString());
        }
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(dispatch -> dispatch.onConnection(addr, profile, result));
        }
    }

    @ApiStatus.Internal
    public void onPreCreatePlayer(GameProfile profile) {
        this.lastProfile = profile;
    }

    @ApiStatus.Internal
    public void onCreatePlayer(class_3222 player, @Nullable GameProfile profile) {
        CoreLib.debugLog("onCreatePlayer: {}", player.method_5477().getString());
        if (profile == null && this.lastProfile != null) {
            profile = this.lastProfile;
        }
        GameProfile profile2 = profile;
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(dispatch -> dispatch.onCreatePlayer(player, profile2));
        }
        this.lastProfile = null;
    }

    @ApiStatus.Internal
    public void onPlayerJoinPre(class_3222 player, class_2535 connection) {
        CoreLib.debugLog("onPlayerJoinPre: {} is joining.", player.method_5477().getString());
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(dispatch -> dispatch.onPlayerJoinPre(player, connection));
        }
    }

    @ApiStatus.Internal
    public void onPlayerJoinPost(class_3222 player, class_2535 connection) {
        CoreLib.debugLog("onPlayerJoinPost: {} has joined.", player.method_5477().getString());
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(dispatch -> dispatch.onPlayerJoinPost(player, connection));
        }
    }

    @ApiStatus.Internal
    public void onPlayerRespawn(class_3222 newPlayer) {
        CoreLib.debugLog("onPlayerRespawn: {} has respawned.", newPlayer.method_5477().getString());
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(dispatch -> dispatch.onPlayerRespawn(newPlayer));
        }
    }

    @ApiStatus.Internal
    public void onPlayerLeave(class_3222 player) {
        CoreLib.debugLog("onPlayerLeave: {} has left.", player.method_5477().getString());
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(dispatch -> dispatch.onPlayerLeave(player));
        }
    }

    @ApiStatus.Internal
    public void onDisconnectAll() {
        CoreLib.debugLog("onDisconnectAll: disconnect all clients.", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(IPlayerEventsDispatch::onDisconnectAll);
        }
    }

    @ApiStatus.Internal
    public void onSetViewDistance(int distance) {
        CoreLib.debugLog("onSetViewDistance: setViewDistance to {}", distance);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(dispatch -> dispatch.onSetViewDistance(distance));
        }
    }

    @ApiStatus.Internal
    public void onSetSimulationDistance(int distance) {
        CoreLib.debugLog("onSetSimulationDistance: setSimulationDistance to {}", distance);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(dispatch -> dispatch.onSetSimulationDistance(distance));
        }
    }
}

