/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.events.server;

import com.sakuraryoko.corelib.api.events.IServerEventsDispatch;
import com.sakuraryoko.corelib.impl.CoreLib;
import com.sakuraryoko.corelib.impl.events.server.IServerEventManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1132;
import net.minecraft.class_1934;
import net.minecraft.class_3176;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class ServerEventsManager
implements IServerEventManager {
    private static final ServerEventsManager INSTANCE = new ServerEventsManager();
    private final List<IServerEventsDispatch> DISPATCH = new ArrayList<IServerEventsDispatch>();

    public static IServerEventManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerEventDispatcher(IServerEventsDispatch handler) throws RuntimeException {
        if (this.DISPATCH.contains(handler)) {
            throw new RuntimeException("Server Events Dispatcher has already been registered!");
        }
        this.DISPATCH.add(handler);
    }

    @ApiStatus.Internal
    public void onStartingInternal(MinecraftServer server) {
        CoreLib.debugLog("onStartingInternal()", new Object[0]);
        for (IServerEventsDispatch dispatch : this.DISPATCH) {
            dispatch.onStarting(server);
        }
    }

    @ApiStatus.Internal
    public void onStartedInternal(MinecraftServer server) {
        CoreLib.debugLog("onStartedInternal()", new Object[0]);
        for (IServerEventsDispatch dispatch : this.DISPATCH) {
            dispatch.onStarted(server);
        }
    }

    @ApiStatus.Internal
    public void onReloadCompleteInternal(MinecraftServer server, Collection<String> resources) {
        CoreLib.debugLog("onReloadCompleteInternal()", new Object[0]);
        for (IServerEventsDispatch dispatch : this.DISPATCH) {
            dispatch.onReloadComplete(server, resources);
        }
    }

    @ApiStatus.Internal
    public void onIntegratedStartedInternal(class_1132 server) {
        CoreLib.debugLog("onIntegratedStartedInternal()", new Object[0]);
        for (IServerEventsDispatch dispatch : this.DISPATCH) {
            dispatch.onIntegratedStarted(server);
        }
    }

    @ApiStatus.Internal
    public void onDedicatedStartedInternal(class_3176 server) {
        CoreLib.debugLog("onDedicatedStartedInternal()", new Object[0]);
        for (IServerEventsDispatch dispatch : this.DISPATCH) {
            dispatch.onDedicatedStarted(server);
        }
    }

    @ApiStatus.Internal
    public void onOpenToLanInternal(class_1132 server, class_1934 mode) {
        CoreLib.debugLog("onOpenToLanInternal()", new Object[0]);
        for (IServerEventsDispatch dispatch : this.DISPATCH) {
            dispatch.onOpenToLan(server, mode);
        }
    }

    @ApiStatus.Internal
    public void onDedicatedStoppingInternal(class_3176 server) {
        CoreLib.debugLog("onDedicatedStoppingInternal()", new Object[0]);
        for (IServerEventsDispatch dispatch : this.DISPATCH) {
            dispatch.onDedicatedStopping(server);
        }
    }

    @ApiStatus.Internal
    public void onStoppingInternal(MinecraftServer server) {
        CoreLib.debugLog("onStoppingInternal()", new Object[0]);
        for (IServerEventsDispatch dispatch : this.DISPATCH) {
            dispatch.onStopping(server);
        }
    }

    @ApiStatus.Internal
    public void onStoppedInternal(MinecraftServer server) {
        CoreLib.debugLog("onStoppedInternal()", new Object[0]);
        for (IServerEventsDispatch dispatch : this.DISPATCH) {
            dispatch.onStopped(server);
        }
    }
}

