/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.api.time;

import com.google.common.collect.ImmutableList;
import com.sakuraryoko.corelib.impl.time.DurationFmtType;
import com.sakuraryoko.corelib.impl.time.formatter.DurationFmt;
import javax.annotation.Nullable;

public enum DurationFormat {
    REGULAR("regular", DurationFmtType.REGULAR),
    PRETTY("pretty", DurationFmtType.PRETTY),
    ISO_EXTENDED("iso_extended", DurationFmtType.ISO_EXTENDED),
    FORMATTED("formatted", DurationFmtType.FORMATTED);

    public static final ImmutableList<DurationFormat> VALUES;
    final String name;
    final DurationFmtType<?> type;

    private DurationFormat(String name, DurationFmtType<?> type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public DurationFmtType<?> getType() {
        return this.type;
    }

    @Nullable
    public DurationFmt init() {
        return this.type.init(this);
    }

    public String format(long duration) {
        return this.format(duration, null);
    }

    public String format(long duration, @Nullable String fmt) {
        DurationFmt formatter = this.init();
        if (formatter != null) {
            if (duration < 1L) {
                return "Invalid Duration [" + duration + "]";
            }
            return formatter.format(duration, fmt);
        }
        return "";
    }

    public String getFormatString() {
        DurationFmt formatter = this.init();
        if (formatter != null) {
            return formatter.getFormatString();
        }
        return "";
    }

    @Nullable
    public DurationFormat fromString(String value) {
        return DurationFormat.fromStringStatic(value);
    }

    @Nullable
    public static DurationFormat fromStringStatic(String name) {
        for (DurationFormat val : VALUES) {
            if (name.compareToIgnoreCase(val.getName()) != 0) continue;
            return val;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])DurationFormat.values());
    }
}

