/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.api.time;

import com.google.common.collect.ImmutableList;
import com.sakuraryoko.corelib.impl.time.TimeFmtType;
import com.sakuraryoko.corelib.impl.time.formatter.TimeFmt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum TimeFormat {
    REGULAR("regular", TimeFmtType.REGULAR),
    ISO_LOCAL("iso_local", TimeFmtType.ISO_LOCAL),
    ISO_OFFSET("iso_offset", TimeFmtType.ISO_OFFSET),
    FORMATTED("formatted", TimeFmtType.FORMATTED),
    RFC1123("rfc1123", TimeFmtType.RFC1123),
    TIME_ONLY("time_only", TimeFmtType.TIME_ONLY),
    DATE_ONLY("date_only", TimeFmtType.DATE_ONLY);

    public static final ImmutableList<TimeFormat> VALUES;
    final String name;
    final TimeFmtType<?> type;

    private TimeFormat(String name, TimeFmtType<?> type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public TimeFmtType<?> getType() {
        return this.type;
    }

    @Nullable
    public TimeFmt init() {
        return this.type.init(this);
    }

    public String formatTo(long time) {
        return this.formatTo(time, null);
    }

    public String formatTo(long time, @Nullable String fmt) {
        TimeFmt formatter = this.init();
        if (formatter != null) {
            return formatter.formatTo(time, fmt);
        }
        return "";
    }

    public long formatFrom(@Nonnull String formattedTime) {
        return this.formatFrom(formattedTime, null);
    }

    public long formatFrom(@Nonnull String formattedTime, @Nullable String fmt) {
        TimeFmt formatter = this.init();
        if (formatter != null) {
            return formatter.formatFrom(formattedTime, fmt);
        }
        return 0L;
    }

    public String formatNow() {
        return this.formatNow(null);
    }

    public String formatNow(@Nullable String fmt) {
        TimeFmt formatter = this.init();
        if (formatter != null) {
            return formatter.formatNow(fmt);
        }
        return "";
    }

    public String getFormatString() {
        TimeFmt formatter = this.init();
        if (formatter != null) {
            return formatter.getFormatString();
        }
        return "";
    }

    @Nullable
    public TimeFormat fromString(String value) {
        return TimeFormat.fromStringStatic(value);
    }

    @Nullable
    public static TimeFormat fromStringStatic(String name) {
        for (TimeFormat val : VALUES) {
            if (name.compareToIgnoreCase(val.getName()) != 0) continue;
            return val;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])TimeFormat.values());
    }
}

