/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.modinit;

import com.sakuraryoko.corelib.api.log.AnsiLogger;
import com.sakuraryoko.corelib.api.modinit.IModInitDispatcher;
import com.sakuraryoko.corelib.impl.modinit.IModInitManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public class ModInitManager
implements IModInitManager {
    private final AnsiLogger LOGGER = new AnsiLogger(this.getClass(), false);
    private static final ModInitManager INSTANCE = new ModInitManager();
    private final List<IModInitDispatcher> DISPATCH = new ArrayList<IModInitDispatcher>();

    public static IModInitManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerModInitHandler(IModInitDispatcher handler) throws RuntimeException {
        this.LOGGER.debug("registerModInitHandler()", new Object[0]);
        if (!this.DISPATCH.contains(handler)) {
            this.DISPATCH.add(handler);
            if (!handler.isInitComplete()) {
                handler.onModInit();
            }
        } else {
            throw new RuntimeException("Mod Init Dispatcher already registered!");
        }
    }

    @ApiStatus.Internal
    public void onModInit() {
        this.LOGGER.debug("onModInit()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> {
                if (!handler.isInitComplete()) {
                    handler.onModInit();
                }
            });
        }
    }

    @ApiStatus.Internal
    public void setIntegratedServer(boolean toggle) {
        this.LOGGER.debug("setIntegratedServer()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.setIntegratedServer(toggle));
        }
    }

    @ApiStatus.Internal
    public void setDedicatedServer(boolean toggle) {
        this.LOGGER.debug("setDedicatedServer()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.setDedicatedServer(toggle));
        }
    }

    @ApiStatus.Internal
    public void setOpenToLan(boolean toggle) {
        this.LOGGER.debug("setOpenToLan()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(handler -> handler.setOpenToLan(toggle));
        }
    }

    @ApiStatus.Internal
    public void reset() {
        this.LOGGER.debug("reset()", new Object[0]);
        if (!this.DISPATCH.isEmpty()) {
            this.DISPATCH.forEach(IModInitDispatcher::reset);
        }
    }
}

