/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.morecolors.impl.nodes;

import com.sakuraryoko.morecolors.api.MoreColorsEvents;
import com.sakuraryoko.morecolors.impl.MoreColor;
import com.sakuraryoko.morecolors.impl.config.ConfigWrap;
import com.sakuraryoko.morecolors.impl.nodes.MoreColorNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_5251;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NodeManager {
    private static final List<MoreColorNode> REMOVE = new ArrayList<MoreColorNode>();

    @ApiStatus.Internal
    private static void registerColors(boolean cleanup) {
        Iterator<MoreColorNode> iterator = ConfigWrap.colors().iterator();
        REMOVE.clear();
        while (iterator.hasNext()) {
            MoreColorNode iColorNode = iterator.next();
            NodeManager.registerColor(iColorNode);
        }
        if (!REMOVE.isEmpty() && cleanup) {
            REMOVE.forEach(iNode -> {
                MoreColor.LOGGER.warn("Removing Node \"{}\" from config, because it was detected as being in use.", (Object)iNode.getName());
                ConfigWrap.colors().remove(iNode);
            });
            REMOVE.clear();
        }
    }

    @ApiStatus.Internal
    public static void registerColor(MoreColorNode iColorNode) {
        MoreColor.debugLog("registerColors(): register ColorNode: {} // {}", iColorNode.getName(), iColorNode.getHexCode());
        class_5251 finalIColorNode = iColorNode.getColor();
        if (NodeManager.checkIfRegistered(iColorNode)) {
            MoreColor.debugLog("registerColors(): A tag named \"{}\" is already registered.", iColorNode.getName());
            REMOVE.add(iColorNode);
            return;
        }
        if (iColorNode.getAliases() != null) {
            TagRegistry.registerDefault((TextTag)TextTag.enclosing((String)iColorNode.getName(), iColorNode.getAliases(), (String)"color", (boolean)true, (nodes, data, parser) -> new ColorNode(nodes, finalIColorNode)));
            ((MoreColorsEvents.RegisterColorEvent)MoreColorsEvents.REGISTER_COLOR_NODE.invoker()).onRegisterMoreColorNode(iColorNode.getName(), iColorNode.getHexCode(), iColorNode.getAliases());
        } else {
            TagRegistry.registerDefault((TextTag)TextTag.enclosing((String)iColorNode.getName(), List.of(""), (String)"color", (boolean)true, (nodes, data, parser) -> new ColorNode(nodes, finalIColorNode)));
            ((MoreColorsEvents.RegisterColorEvent)MoreColorsEvents.REGISTER_COLOR_NODE.invoker()).onRegisterMoreColorNode(iColorNode.getName(), iColorNode.getHexCode(), null);
        }
    }

    @ApiStatus.Internal
    public static boolean isMoreColorNode(String node) {
        AtomicBoolean atomic = new AtomicBoolean(false);
        ConfigWrap.colors().forEach(iNode -> {
            if (node.equals(iNode.getName()) || iNode.getAliases() != null && iNode.getAliases().contains(node)) {
                atomic.set(true);
            }
        });
        return atomic.get();
    }

    @ApiStatus.Internal
    public static void registerNodes(boolean fromInit) {
        NodeManager.registerColors(fromInit);
    }

    @ApiStatus.Internal
    public static boolean checkIfRegistered(MoreColorNode colorNode) {
        return TagRegistry.DEFAULT.getTag(colorNode.getName()) != null;
    }

    @ApiStatus.Internal
    public static List<String> getAllColorNodes() {
        ArrayList<String> nodes = new ArrayList<String>();
        TagRegistry.DEFAULT.getTags().forEach(tag -> {
            if (Objects.equals(tag.type(), "color") && !nodes.contains(tag.name()) && !Objects.equals(tag.name(), "reset") && !Objects.equals(tag.name(), "color")) {
                nodes.add(tag.name());
            }
        });
        return nodes;
    }
}

