/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.impl.time.formatter;

import com.sakuraryoko.corelib.api.time.TimeFormat;
import com.sakuraryoko.corelib.impl.CoreLib;
import com.sakuraryoko.corelib.impl.time.formatter.TimeFmt;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TimeFmtFormatted
extends TimeFmt {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);

    public TimeFmtFormatted(TimeFormat fmt) {
        super(fmt);
        this.formatString = "yyyy-MM-dd_HH.mm.ss";
    }

    @Override
    public String formatTo(long time, @Nullable String fmt) {
        DateTimeFormatter format;
        if (fmt != null && !fmt.isEmpty() && (format = this.setFormat(fmt)) != null) {
            return format.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
        }
        return this.formatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()));
    }

    @Override
    public long formatFrom(@Nonnull String formatted, @Nullable String fmt) {
        LocalDateTime dateTime;
        DateTimeFormatter format;
        if (fmt != null) {
            format = this.setFormat(fmt);
            if (format == null) {
                return 0L;
            }
        } else {
            format = this.formatter;
        }
        try {
            dateTime = LocalDateTime.parse(formatted, format);
        }
        catch (Exception err) {
            CoreLib.LOGGER.error("fromFormat(): Invalid Date/Time format // {}", (Object)err.getMessage());
            return 0L;
        }
        return dateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    @Override
    public String formatNow(@Nullable String fmt) {
        DateTimeFormatter format;
        if (fmt != null && !fmt.isEmpty() && (format = this.setFormat(fmt)) != null) {
            return format.format(ZonedDateTime.now());
        }
        return this.formatter.format(ZonedDateTime.now());
    }

    @Nullable
    private DateTimeFormatter setFormat(@Nonnull String fmt) {
        DateTimeFormatter temp;
        try {
            temp = DateTimeFormatter.ofPattern(fmt, Locale.ROOT);
        }
        catch (IllegalArgumentException err) {
            CoreLib.LOGGER.error("setFormat(): Invalid Date/Time format // {}", (Object)err.getMessage());
            return null;
        }
        this.formatString = fmt;
        return temp;
    }
}

