/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.api.log;

import com.sakuraryoko.corelib.api.log.IAnsiLogger;

public class AnsiLogger
implements IAnsiLogger {
    private final String log;
    private final boolean debug;

    public AnsiLogger(Class<?> clazz) {
        this(clazz, false);
    }

    public AnsiLogger(Class<?> clazz, boolean debug) {
        this.log = clazz.getName();
        this.debug = debug;
    }

    @Override
    public void info(String fmt, Object ... args) {
        if (this.log != null) {
            String msg = this.format(fmt, args);
            System.out.printf("\u001b[0;37m[INFO/" + this.log + "]: %s" + "\u001b[0m" + "\n", msg);
        }
    }

    @Override
    public void debug(String fmt, Object ... args) {
        if (this.log != null && this.debug) {
            String msg = this.format(fmt, args);
            System.out.printf("\u001b[1;35m[DEBUG/" + this.log + "]: %s" + "\u001b[0m" + "\n", msg);
        }
    }

    @Override
    public void warn(String fmt, Object ... args) {
        if (this.log != null) {
            String msg = this.format(fmt, args);
            System.out.printf("\u001b[1;33m[WARN/" + this.log + "]: %s" + "\u001b[0m" + "\n", msg);
        }
    }

    @Override
    public void error(String fmt, Object ... args) {
        if (this.log != null) {
            String msg = this.format(fmt, args);
            System.out.printf("\u001b[1;31m[ERROR/" + this.log + "]: %s" + "\u001b[0m" + "\n", msg);
        }
    }

    @Override
    public void fatal(String fmt, Object ... args) {
        if (this.log != null) {
            String msg = this.format(fmt, args);
            System.out.printf("\u001b[1;91m[FATAL/" + this.log + "]: %s" + "\u001b[0m" + "\n", msg);
        }
    }
}

