/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.corelib.test;

import com.sakuraryoko.corelib.api.config.IConfigData;
import com.sakuraryoko.corelib.api.config.IConfigDispatch;
import com.sakuraryoko.corelib.api.log.AnsiLogger;
import com.sakuraryoko.corelib.api.time.TimeFormat;
import com.sakuraryoko.corelib.impl.modinit.CoreInit;
import com.sakuraryoko.corelib.test.TestConfigData;
import com.sakuraryoko.corelib.test.TestConfigOptions;
import java.util.Objects;

public class TestConfigHandler
implements IConfigDispatch {
    private final AnsiLogger LOGGER = new AnsiLogger(this.getClass(), false);
    private static final TestConfigHandler INSTANCE = new TestConfigHandler();
    private final TestConfigData CONFIG = this.newConfig();
    private final String CONFIG_ROOT = "corelib-test";
    private final String CONFIG_NAME = "corelib-test";
    private boolean loaded = false;

    public static TestConfigHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getConfigRoot() {
        Objects.requireNonNull(this);
        return "corelib-test";
    }

    @Override
    public boolean useRootDir() {
        return false;
    }

    @Override
    public String getConfigName() {
        Objects.requireNonNull(this);
        return "corelib-test";
    }

    @Override
    public TestConfigData newConfig() {
        return new TestConfigData();
    }

    @Override
    public IConfigData getConfig() {
        return this.CONFIG;
    }

    public TestConfigOptions getTestOptions() {
        return this.CONFIG.TEST;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void initConfig() {
        this.LOGGER.debug("initConfig()", new Object[0]);
    }

    @Override
    public void onPreLoadConfig() {
        this.loaded = false;
    }

    @Override
    public void onPostLoadConfig() {
        this.loaded = true;
    }

    @Override
    public void onPreSaveConfig() {
        this.loaded = false;
    }

    @Override
    public void onPostSaveConfig() {
        this.loaded = true;
    }

    @Override
    public TestConfigData defaults() {
        TestConfigData config = this.newConfig();
        this.LOGGER.debug("defaults()", new Object[0]);
        config.config_date = TimeFormat.RFC1123.formatNow();
        config.TEST.defaults();
        return config;
    }

    @Override
    public TestConfigData update(IConfigData newConfig) {
        TestConfigData newConf = (TestConfigData)newConfig;
        this.LOGGER.debug("update()", new Object[0]);
        this.CONFIG.comment = CoreInit.getInstance().getModVersionString() + " Config";
        this.CONFIG.config_date = TimeFormat.RFC1123.formatNow();
        this.LOGGER.info("update(): save_date: {} --> {}", newConf.config_date, this.CONFIG.config_date);
        this.CONFIG.TEST.copy(newConf.TEST);
        return this.CONFIG;
    }

    @Override
    public void execute(boolean fromInit) {
        this.LOGGER.debug("execute()", new Object[0]);
    }
}

