/*
 * Decompiled with CFR 0.152.
 */
package com.sakuraryoko.morecolors.impl.config;

import com.sakuraryoko.corelib.api.config.IConfigData;
import com.sakuraryoko.corelib.api.config.IConfigDispatch;
import com.sakuraryoko.corelib.api.time.TimeFormat;
import com.sakuraryoko.morecolors.impl.MoreColor;
import com.sakuraryoko.morecolors.impl.config.data.MoreColorData;
import com.sakuraryoko.morecolors.impl.config.data.options.MainOptions;
import com.sakuraryoko.morecolors.impl.modinit.MoreColorInit;
import com.sakuraryoko.morecolors.impl.nodes.MoreColorNode;
import com.sakuraryoko.morecolors.impl.nodes.NodeManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MoreColorConfigHandler
implements IConfigDispatch {
    private static final MoreColorConfigHandler INSTANCE = new MoreColorConfigHandler();
    private final MoreColorData CONFIG = this.newConfig();
    private final String CONFIG_ROOT = "more-color-api";
    private final String CONFIG_NAME = "more-color-api";
    private boolean loaded = false;

    public static MoreColorConfigHandler getInstance() {
        return INSTANCE;
    }

    public String getConfigRoot() {
        Objects.requireNonNull(this);
        return "more-color-api";
    }

    public boolean useRootDir() {
        return true;
    }

    public String getConfigName() {
        Objects.requireNonNull(this);
        return "more-color-api";
    }

    public MoreColorData newConfig() {
        return new MoreColorData();
    }

    public MoreColorData getConfig() {
        return this.CONFIG;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void initConfig() {
    }

    public MainOptions getMainOptions() {
        return this.CONFIG.MAIN;
    }

    public List<MoreColorNode> getColors() {
        return this.CONFIG.COLORS;
    }

    public void onPreLoadConfig() {
        this.loaded = false;
    }

    public void onPostLoadConfig() {
        this.loaded = true;
    }

    public void onPreSaveConfig() {
        this.loaded = false;
    }

    public void onPostSaveConfig() {
        this.loaded = true;
    }

    public MoreColorData defaults() {
        MoreColorData config = this.newConfig();
        MoreColor.debugLog("MoreColorConfigHandler#defaults(): Setting default config.", new Object[0]);
        config.config_date = TimeFormat.RFC1123.formatNow(null);
        config.MAIN.defaults();
        config.COLORS = new ArrayList<MoreColorNode>();
        config.COLORS.add(new MoreColorNode("aztec_gold", "#C39953"));
        config.COLORS.add(new MoreColorNode("bluetiful", "#3C69E7", List.of("blue2")));
        config.COLORS.add(new MoreColorNode("brown", "#632C04"));
        config.COLORS.add(new MoreColorNode("burnt_orange", "#FF7034", List.of("orange2")));
        config.COLORS.add(new MoreColorNode("canary", "#FFFF99", List.of("yellow2")));
        config.COLORS.add(new MoreColorNode("cool_mint", "#DDEBEC"));
        config.COLORS.add(new MoreColorNode("copper", "#DA8A67"));
        config.COLORS.add(new MoreColorNode("cotton_candy", "#FFB7D5"));
        config.COLORS.add(new MoreColorNode("cyan", "#2D7C9D"));
        config.COLORS.add(new MoreColorNode("dark_brown", "#421F05"));
        config.COLORS.add(new MoreColorNode("dark_pink", "#DE8BB4"));
        config.COLORS.add(new MoreColorNode("lavender", "#BF8FCC"));
        config.COLORS.add(new MoreColorNode("light_blue", "#82ACE7"));
        config.COLORS.add(new MoreColorNode("light_brown", "#7A4621"));
        config.COLORS.add(new MoreColorNode("light_gray", "#BABAC1", List.of("light_grey")));
        config.COLORS.add(new MoreColorNode("light_pink", "#F7B4D6"));
        config.COLORS.add(new MoreColorNode("lime", "#76C610"));
        config.COLORS.add(new MoreColorNode("magenta", "#CB69C5"));
        config.COLORS.add(new MoreColorNode("maroon", "#C32148"));
        config.COLORS.add(new MoreColorNode("orange", "#E69E34"));
        config.COLORS.add(new MoreColorNode("pink", "#EDA7CB"));
        config.COLORS.add(new MoreColorNode("pacific_blue", "#009DC4"));
        config.COLORS.add(new MoreColorNode("peach", "#FFCBA4"));
        config.COLORS.add(new MoreColorNode("plum", "#843179"));
        config.COLORS.add(new MoreColorNode("powder_blue", "#C0D5F0"));
        config.COLORS.add(new MoreColorNode("purple", "#A453CE"));
        config.COLORS.add(new MoreColorNode("royal_purple", "#6B3FA0"));
        config.COLORS.add(new MoreColorNode("salmon", "#FF91A4", List.of("pink_salmon")));
        config.COLORS.add(new MoreColorNode("scarlet", "#FD0E35"));
        config.COLORS.add(new MoreColorNode("sea_green", "#93DFB8"));
        config.COLORS.add(new MoreColorNode("sepia", "#9E5B40"));
        config.COLORS.add(new MoreColorNode("shamrock", "#33CC99"));
        config.COLORS.add(new MoreColorNode("sunset_orange", "#FE4C40"));
        config.COLORS.add(new MoreColorNode("tickle_me_pink", "#FC80A5"));
        config.COLORS.add(new MoreColorNode("timberwolf", "#D9D6CF"));
        config.COLORS.add(new MoreColorNode("ultramarine_blue", "#3F26BF", List.of("ultramarine")));
        return config;
    }

    public MoreColorData update(IConfigData newConfig) {
        MoreColorData newConf = (MoreColorData)newConfig;
        MoreColor.debugLog("MoreColorConfigHandler#update(): Refresh config.", new Object[0]);
        this.CONFIG.comment = MoreColorInit.getInstance().getModVersionString() + " Config";
        this.CONFIG.config_date = TimeFormat.RFC1123.formatNow(null);
        MoreColor.debugLog("MoreColorConfigHandler#update(): save_date: {} --> {}", newConf.config_date, this.CONFIG.config_date);
        this.CONFIG.MAIN.copy(newConf.MAIN);
        this.CONFIG.COLORS.clear();
        this.CONFIG.COLORS.addAll(newConf.COLORS);
        return this.CONFIG;
    }

    public void execute(boolean fromInit) {
        MoreColor.debugLog("MoreColorConfigHandler#execute(): Execute config.", new Object[0]);
        MoreColor.debugLog("MoreColorConfigHandler#execute(): new config_date: {}", this.CONFIG.config_date);
        NodeManager.registerNodes(fromInit);
    }
}

